// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Storage_Root_HeaderFile
#define _Storage_Root_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Storage_Root_HeaderFile
#include <Handle_Storage_Root.hxx>
#endif

#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Handle_Standard_Persistent_HeaderFile
#include <Handle_Standard_Persistent.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
class Standard_Persistent;
class Storage_Schema;
class TCollection_AsciiString;



//! A root object extracted from a Storage_Data object. <br>
//! A Storage_Root encapsulates a persistent <br>
//! object which is a root of a Storage_Data object. <br>
//! It contains additional information: the name and <br>
//! the data type of the persistent object. <br>
//! When retrieving a Storage_Data object from a <br>
//! container (for example, a file) you access its <br>
//! roots with the function Roots which returns a <br>
//! sequence of root objects. The provided functions <br>
//! allow you to request information about each root of the sequence. <br>
//! You do not create explicit roots: when inserting <br>
//! data in a Storage_Data object, you just provide <br>
//! the persistent object and optionally its name to the function AddRoot. <br>
class Storage_Root : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT Storage_Root();


Standard_EXPORT Storage_Root(const TCollection_AsciiString& aName,const Handle(Standard_Persistent)& anObject);


Standard_EXPORT   void SetName(const TCollection_AsciiString& aName) ;


//! Returns the name of this root object. <br>
//!   The name may have been given explicitly when <br>
//! the root was inserted into the Storage_Data <br>
//! object. If not, the name is a reference number <br>
//! which was assigned automatically by the driver <br>
//! when writing the set of data into the container. <br>
//! When naming the roots, it is easier to retrieve <br>
//! objects by significant references rather than by <br>
//! references without any semantic values. <br>
//! Warning <br>
//! The returned string will be empty if you call this <br>
//! function before having named this root object, <br>
//! either explicitly, or when writing the set of data <br>
//! into the container. <br>
Standard_EXPORT   TCollection_AsciiString Name() const;


Standard_EXPORT   void SetObject(const Handle(Standard_Persistent)& anObject) ;


//! Returns the persistent object encapsulated by this root. <br>
Standard_EXPORT   Handle_Standard_Persistent Object() const;

//! Returns the name of this root type. <br>
Standard_EXPORT   TCollection_AsciiString Type() const;
//Standard_EXPORT ~Storage_Root();


friend class Storage_Schema;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void SetReference(const Standard_Integer aRef) ;


Standard_EXPORT   Standard_Integer Reference() const;


Standard_EXPORT   void SetType(const TCollection_AsciiString& aType) ;


 // Fields PRIVATE
 //
TCollection_AsciiString myName;
TCollection_AsciiString myType;
Handle_Standard_Persistent myObject;
Standard_Integer myRef;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
