// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _OSD_SharedMemory_HeaderFile
#define _OSD_SharedMemory_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _OSD_Error_HeaderFile
#include <OSD_Error.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_ConstructionError;
class Standard_NullObject;
class OSD_OSDError;
class Standard_ProgramError;
class TCollection_AsciiString;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! IPC Tools -Shared Memory <br>
//!          This is a low level interface for communications. <br>
//!          Using shared memory, processes can use a common area to <br>
//!          communicate. <br>
//!          You can create and delete a shared memory. <br>
class OSD_SharedMemory  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Allocates room for shared memory name. <br>
//!          This is to be used with 'Open'. <br>
//!          In this case, the process is a client of shared memory. <br>
Standard_EXPORT OSD_SharedMemory();

//! Instantiates SharedMemory object with parameters. <br>
//!          A name to make sure shared memory is unique and a size in <br>
//!          bytes for the size of shared memory. <br>
Standard_EXPORT OSD_SharedMemory(const TCollection_AsciiString& Name,const Standard_Integer size);

//! Creates a shared memory in the system <br>
//!          This is for a server process. <br>
Standard_EXPORT   void Build() ;

//! Opens a shared memory <br>
//!          Raises ConstructionError when the name contains characters <br>
//!          not in range of ' '...'~'. <br>
//!          Raises ProgramError when the size given is negative or null. <br>
//!          This is for a server process. <br>
//! <br>
Standard_EXPORT   void Open(const TCollection_AsciiString& Name,const Standard_Integer size) ;

//! Removes a shared memory access. <br>
//!          This is used only by a server process ! <br>
Standard_EXPORT   void Delete() ;

//! Returns address of shared memory. <br>
//!          Raises NullObject when the Shared Memory is not created. <br>
Standard_EXPORT   Standard_Address GiveAddress() const;

//! Returns TRUE if an error occurs <br>
Standard_EXPORT   Standard_Boolean Failed() const;

//! Resets error counter to zero <br>
Standard_EXPORT   void Reset() ;

//! Raises OSD_Error <br>
Standard_EXPORT   void Perror() ;

//! Returns error number if 'Failed' is TRUE. <br>
Standard_EXPORT   Standard_Integer Error() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer myId;
Standard_Address myAddress;
TCollection_AsciiString myName;
Standard_Integer mySize;
OSD_Error myError;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
