// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MeshVS_NodalColorPrsBuilder_HeaderFile
#define _MeshVS_NodalColorPrsBuilder_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_MeshVS_NodalColorPrsBuilder_HeaderFile
#include <Handle_MeshVS_NodalColorPrsBuilder.hxx>
#endif

#ifndef _MeshVS_DataMapOfIntegerColor_HeaderFile
#include <MeshVS_DataMapOfIntegerColor.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Aspect_SequenceOfColor_HeaderFile
#include <Aspect_SequenceOfColor.hxx>
#endif
#ifndef _TColStd_DataMapOfIntegerReal_HeaderFile
#include <TColStd_DataMapOfIntegerReal.hxx>
#endif
#ifndef _Quantity_Color_HeaderFile
#include <Quantity_Color.hxx>
#endif
#ifndef _MeshVS_PrsBuilder_HeaderFile
#include <MeshVS_PrsBuilder.hxx>
#endif
#ifndef _Handle_MeshVS_Mesh_HeaderFile
#include <Handle_MeshVS_Mesh.hxx>
#endif
#ifndef _MeshVS_DisplayModeFlags_HeaderFile
#include <MeshVS_DisplayModeFlags.hxx>
#endif
#ifndef _Handle_MeshVS_DataSource_HeaderFile
#include <Handle_MeshVS_DataSource.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _MeshVS_BuilderPriority_HeaderFile
#include <MeshVS_BuilderPriority.hxx>
#endif
#ifndef _Handle_Prs3d_Presentation_HeaderFile
#include <Handle_Prs3d_Presentation.hxx>
#endif
#ifndef _TColStd_PackedMapOfInteger_HeaderFile
#include <TColStd_PackedMapOfInteger.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Graphic3d_Texture2D_HeaderFile
#include <Handle_Graphic3d_Texture2D.hxx>
#endif
class MeshVS_Mesh;
class MeshVS_DataSource;
class Prs3d_Presentation;
class MeshVS_DataMapOfIntegerColor;
class Quantity_Color;
class Aspect_SequenceOfColor;
class TColStd_DataMapOfIntegerReal;
class Graphic3d_Texture2D;


//! This class provides methods to create presentation of nodes with assigned color. <br>
//! There are two ways of presentation building <br>
//! 1. Without using texture. <br>
//! In this case colors of nodes are specified with DataMapOfIntegerColor and presentation <br>
//! is built with gradient fill between these nodes (default behaviour) <br>
//! 2. Using texture. <br>
//! In this case presentation is built with spectrum filling between nodes. For example, if <br>
//! one node has blue color and second one has violet color, parameters of this class may be <br>
//! set to fill presentation between nodes with solar spectrum. <br>
//! Methods: <br>
//! UseTexture - activates/deactivates this way <br>
//! SetColorMap - sets colors used for generation of texture <br>
//! SetColorindices - specifies correspondence between node IDs and indices of colors from color map <br>
class MeshVS_NodalColorPrsBuilder : public MeshVS_PrsBuilder {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT MeshVS_NodalColorPrsBuilder(const Handle(MeshVS_Mesh)& Parent,const MeshVS_DisplayModeFlags& Flags = MeshVS_DMF_NodalColorDataPrs,const Handle(MeshVS_DataSource)& DS = 0,const Standard_Integer Id = -1,const MeshVS_BuilderPriority& Priority = MeshVS_BP_NodalColor);

//! Builds presentation of nodes with assigned color. <br>
Standard_EXPORT virtual  void Build(const Handle(Prs3d_Presentation)& Prs,const TColStd_PackedMapOfInteger& IDs,TColStd_PackedMapOfInteger& IDsToExclude,const Standard_Boolean IsElement,const Standard_Integer DisplayMode) const;

//! Returns map of colors assigned to nodes. <br>
Standard_EXPORT  const MeshVS_DataMapOfIntegerColor& GetColors() const;

//! Sets map of colors assigned to nodes. <br>
Standard_EXPORT   void SetColors(const MeshVS_DataMapOfIntegerColor& Map) ;

//! Returns true, if map isn't empty <br>
Standard_EXPORT   Standard_Boolean HasColors() const;

//! Returns color assigned to single node <br>
Standard_EXPORT   Standard_Boolean GetColor(const Standard_Integer ID,Quantity_Color& theColor) const;

//! Sets color assigned to single node <br>
Standard_EXPORT   void SetColor(const Standard_Integer ID,const Quantity_Color& theColor) ;

//! Specify whether texture must be used to build presentation <br>
Standard_EXPORT   void UseTexture(const Standard_Boolean theToUse) ;

//! Verify whether texture is used to build presentation <br>
Standard_EXPORT   Standard_Boolean IsUseTexture() const;

//! Set colors to be used for texrture presentation <br>
//! theColors - colors for valid coordinates (laying in range [0, 1]) <br>
Standard_EXPORT   void SetColorMap(const Aspect_SequenceOfColor& theColors) ;

//! Return colors used for texrture presentation <br>
Standard_EXPORT  const Aspect_SequenceOfColor& GetColorMap() const;

//! Set color representing invalid texture coordinate <br>
//!        (laying outside range [0, 1]) <br>
Standard_EXPORT   void SetInvalidColor(const Quantity_Color& theInvalidColor) ;

//! Return color representing invalid texture coordinate <br>
//!        (laying outside range [0, 1]) <br>
Standard_EXPORT   Quantity_Color GetInvalidColor() const;

//! Specify correspondence between node IDs and texture coordinates (range [0, 1]) <br>
Standard_EXPORT   void SetTextureCoords(const TColStd_DataMapOfIntegerReal& theMap) ;

//! Get correspondence between node IDs and texture coordinates (range [0, 1]) <br>
Standard_EXPORT  const TColStd_DataMapOfIntegerReal& GetTextureCoords() const;

//! Specify correspondence between node ID and texture coordinate (range [0, 1]) <br>
Standard_EXPORT   void SetTextureCoord(const Standard_Integer theID,const Standard_Real theCoord) ;

//! Return correspondence between node IDs and texture coordinate (range [0, 1]) <br>
Standard_EXPORT   Standard_Real GetTextureCoord(const Standard_Integer theID) ;
//Standard_EXPORT ~MeshVS_NodalColorPrsBuilder();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Create texture in accordance with myTextureColorMap <br>
Standard_EXPORT   Handle_Graphic3d_Texture2D CreateTexture() const;


 // Fields PRIVATE
 //
MeshVS_DataMapOfIntegerColor myNodeColorMap;
Standard_Boolean myUseTexture;
Aspect_SequenceOfColor myTextureColorMap;
TColStd_DataMapOfIntegerReal myTextureCoords;
Quantity_Color myInvalidColor;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
