// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _HLRBRep_FaceIterator_HeaderFile
#define _HLRBRep_FaceIterator_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_HLRAlgo_WiresBlock_HeaderFile
#include <Handle_HLRAlgo_WiresBlock.hxx>
#endif
#ifndef _Handle_HLRAlgo_EdgesBlock_HeaderFile
#include <Handle_HLRAlgo_EdgesBlock.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopAbs_Orientation_HeaderFile
#include <TopAbs_Orientation.hxx>
#endif
class HLRAlgo_WiresBlock;
class HLRAlgo_EdgesBlock;
class HLRBRep_FaceData;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class HLRBRep_FaceIterator  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT HLRBRep_FaceIterator();

//! Begin an exploration of the edges of the face <fd> <br>
Standard_EXPORT   void InitEdge(HLRBRep_FaceData& fd) ;

  Standard_Boolean MoreEdge() const;


Standard_EXPORT   void NextEdge() ;
//! Returns True if the current edge is the first of a <br>
//!          wire. <br>
//! <br>
  Standard_Boolean BeginningOfWire() const;
//! Returns True if the current edge is the  last of a <br>
//!          wire. <br>
//! <br>
  Standard_Boolean EndOfWire() const;
//! Skip the current wire in the exploration. <br>
//! <br>
  void SkipWire() ;
//! Returns the edges of the current wire. <br>
//! <br>
  Handle_HLRAlgo_EdgesBlock Wire() const;

  Standard_Integer Edge() const;

  TopAbs_Orientation Orientation() const;

  Standard_Boolean OutLine() const;

  Standard_Boolean Internal() const;

  Standard_Boolean Double() const;

  Standard_Boolean IsoLine() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer iWire;
Standard_Integer nbWires;
Standard_Integer iEdge;
Standard_Integer nbEdges;
Handle_HLRAlgo_WiresBlock myWires;
Handle_HLRAlgo_EdgesBlock myEdges;


};


#include <HLRBRep_FaceIterator.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
