// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Graphic2d_Vertex_HeaderFile
#define _Graphic2d_Vertex_HeaderFile

#ifndef _Standard_ShortReal_HeaderFile
#include <Standard_ShortReal.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This class allows the creation and update of a <br>
//!	    2D point. <br>
class Graphic2d_Vertex  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates a point with 0.0, 0.0 coordinates. <br>
Standard_EXPORT Graphic2d_Vertex();

//! Creates a point with <AX>, <AY> coordinates. <br>
Standard_EXPORT Graphic2d_Vertex(const Standard_Real AX,const Standard_Real AY);

//! Creates a point with <AX>, <AY> coordinates. <br>
Standard_EXPORT Graphic2d_Vertex(const Standard_ShortReal AX,const Standard_ShortReal AY);

//! Modifies the coordinates of the point <me>. <br>
Standard_EXPORT   void SetCoord(const Quantity_Length Xnew,const Quantity_Length Ynew) ;

//! Modifies the X coordinate of the point <me>. <br>
Standard_EXPORT   void SetXCoord(const Quantity_Length Xnew) ;

//! Modifies the Y coordinate of the point <me>. <br>
Standard_EXPORT   void SetYCoord(const Quantity_Length Ynew) ;

//! Returns the coordinates of the point <me>. <br>
Standard_EXPORT   void Coord(Quantity_Length& AX,Quantity_Length& AY) const;

//! Returns the X coordinates of the point <me>. <br>
Standard_EXPORT   Quantity_Length X() const;

//! Returns the Y coordinate of the point <me>. <br>
Standard_EXPORT   Quantity_Length Y() const;

//! Test if <me> and <other> are the the same vertex. <br>
Standard_EXPORT   Standard_Boolean IsEqual(const Graphic2d_Vertex& other) const;
  Standard_Boolean operator ==(const Graphic2d_Vertex& other) const
{
  return IsEqual(other);
}


//! Returns the distance between <AV1> and <AV2>. <br>
Standard_EXPORT static  Quantity_Length Distance(const Graphic2d_Vertex& AV1,const Graphic2d_Vertex& AV2) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_ShortReal myX;
Standard_ShortReal myY;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
