// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Extrema_FuncExtCS_HeaderFile
#define _Extrema_FuncExtCS_HeaderFile

#ifndef _Adaptor3d_CurvePtr_HeaderFile
#include <Adaptor3d_CurvePtr.hxx>
#endif
#ifndef _Adaptor3d_SurfacePtr_HeaderFile
#include <Adaptor3d_SurfacePtr.hxx>
#endif
#ifndef _gp_Pnt_HeaderFile
#include <gp_Pnt.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _TColStd_SequenceOfReal_HeaderFile
#include <TColStd_SequenceOfReal.hxx>
#endif
#ifndef _Extrema_SequenceOfPOnCurv_HeaderFile
#include <Extrema_SequenceOfPOnCurv.hxx>
#endif
#ifndef _Extrema_SequenceOfPOnSurf_HeaderFile
#include <Extrema_SequenceOfPOnSurf.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _math_FunctionSetWithDerivatives_HeaderFile
#include <math_FunctionSetWithDerivatives.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Standard_OutOfRange;
class Adaptor3d_Curve;
class Adaptor3d_Surface;
class math_Vector;
class math_Matrix;
class Extrema_POnCurv;
class Extrema_POnSurf;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Fonction permettant de rechercher les extrema de la <br>
//!          distance entre une courbe et une surface. <br>
class Extrema_FuncExtCS  : public math_FunctionSetWithDerivatives {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Extrema_FuncExtCS();


Standard_EXPORT Extrema_FuncExtCS(const Adaptor3d_Curve& C,const Adaptor3d_Surface& S);

//! sets the field mysurf of the function. <br>
Standard_EXPORT   void Initialize(const Adaptor3d_Curve& C,const Adaptor3d_Surface& S) ;


Standard_EXPORT   Standard_Integer NbVariables() const;


Standard_EXPORT   Standard_Integer NbEquations() const;

//! Calcul de Fi(U,V). <br>
Standard_EXPORT   Standard_Boolean Value(const math_Vector& UV,math_Vector& F) ;

//! Calcul de Fi'(U,V). <br>
Standard_EXPORT   Standard_Boolean Derivatives(const math_Vector& UV,math_Matrix& DF) ;

//! Calcul de Fi(U,V) et Fi'(U,V). <br>
Standard_EXPORT   Standard_Boolean Values(const math_Vector& UV,math_Vector& F,math_Matrix& DF) ;

//! Memorise l'extremum trouve. <br>
Standard_EXPORT virtual  Standard_Integer GetStateNumber() ;

//! Renvoie le nombre d'extrema trouves. <br>
Standard_EXPORT   Standard_Integer NbExt() const;

//! Renvoie la valeur de la Nieme distance. <br>
Standard_EXPORT   Standard_Real Value(const Standard_Integer N) const;

//! Renvoie le Nieme extremum sur C. <br>
Standard_EXPORT  const Extrema_POnCurv& PointOnCurve(const Standard_Integer N) const;

//! Renvoie le Nieme extremum sur S. <br>
Standard_EXPORT  const Extrema_POnSurf& PointOnSurface(const Standard_Integer N) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   Adaptor3d_SurfacePtr Bidon1() const;


Standard_EXPORT   Adaptor3d_CurvePtr Bidon2() const;


 // Fields PRIVATE
 //
Adaptor3d_CurvePtr myC;
Adaptor3d_SurfacePtr myS;
gp_Pnt myP1;
gp_Pnt myP2;
Standard_Real myt;
Standard_Real myU;
Standard_Real myV;
TColStd_SequenceOfReal myValue;
Extrema_SequenceOfPOnCurv myPoint1;
Extrema_SequenceOfPOnSurf myPoint2;
Standard_Boolean myCinit;
Standard_Boolean mySinit;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
