// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepOffsetAPI_FindContigousEdges_HeaderFile
#define _BRepOffsetAPI_FindContigousEdges_HeaderFile

#ifndef _Handle_BRepBuilderAPI_Sewing_HeaderFile
#include <Handle_BRepBuilderAPI_Sewing.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class BRepBuilderAPI_Sewing;
class Standard_OutOfRange;
class Standard_NoSuchObject;
class TopoDS_Shape;
class TopoDS_Edge;
class TopTools_ListOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides methods to identify contigous boundaries <br>
//!          for continuity control (C0, C1, ...) <br>
//! <br>
//!          Use this function as following: <br>
//!            - create an object <br>
//!                - default tolerance 1.E-06 <br>
//!                - with analysis of degenerated faces on <br>
//!                - define if necessary a new tolerance <br>
//!                - set if necessary analysis of degenerated shapes off <br>
//!            - add shapes to be controlled -> Add <br>
//!            - compute -> Perfom <br>
//!            - output couples of connected edges for control <br>
//!            - output the problems if any <br>
class BRepOffsetAPI_FindContigousEdges  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Initializes an algorithm for identifying contiguous edges <br>
//! on shapes with tolerance as the tolerance of contiguity <br>
//! (defaulted to 1.0e-6). This tolerance value is used to <br>
//! determine whether two edges or sections of edges are coincident. <br>
//! Use the function Add to define the shapes to be checked. <br>
//! Set option to false. This argument (defaulted to true) will <br>
//! serve in subsequent software releases for performing an <br>
//! analysis of degenerated shapes. <br>
Standard_EXPORT BRepOffsetAPI_FindContigousEdges(const Standard_Real tolerance = 1.0e-06,const Standard_Boolean option = Standard_True);

//! Initializes this algorithm for identifying contiguous edges <br>
//! on shapes using the tolerance of contiguity tolerance. <br>
//! This tolerance value is used to determine whether two <br>
//! edges or sections of edges are coincident. <br>
//! Use the function Add to define the shapes to be checked. <br>
//! Sets <option> to false. <br>
Standard_EXPORT   void Init(const Standard_Real tolerance,const Standard_Boolean option) ;

//! Adds the shape shape to the list of shapes to be <br>
//! checked by this algorithm. <br>
//! Once all the shapes to be checked have been added, <br>
//! use the function Perform to find the contiguous edges <br>
//! and the function ContigousEdge to return these edges. <br>
Standard_EXPORT   void Add(const TopoDS_Shape& shape) ;

//! Finds coincident parts of edges of two or more shapes <br>
//! added to this algorithm and breaks down these edges <br>
//! into contiguous and non-contiguous sections on copies <br>
//! of the initial shapes. <br>
//!        The function ContigousEdge returns contiguous <br>
//! edges. The function Modified can be used to return <br>
//! modified copies of the initial shapes where one or more <br>
//! edges were broken down into contiguous and non-contiguous sections. <br>
//! Warning <br>
//! This function must be used once all the shapes to be <br>
//! checked have been added. It is not possible to add <br>
//! further shapes subsequently and then to repeat the call to Perform. <br>
Standard_EXPORT   void Perform() ;

//! Gives  the number  of edges (free  edges + contigous <br>
//!          edges  +  multiple edge) <br>
Standard_EXPORT   Standard_Integer NbEdges() const;

//! Returns the number of contiguous edges found by the <br>
//! function Perform on the shapes added to this algorithm. <br>
Standard_EXPORT   Standard_Integer NbContigousEdges() const;

//! Returns the contiguous edge of index index found by <br>
//! the function Perform on the shapes added to this algorithm. <br>
//! Exceptions <br>
//! Standard_OutOfRange if: <br>
//! - index is less than 1, or <br>
//! - index is greater than the number of contiguous <br>
//!   edges found by the function Perform on the shapes added to this algorithm. <br>
Standard_EXPORT  const TopoDS_Edge& ContigousEdge(const Standard_Integer index) const;

//! Returns a list of edges coincident with the contiguous <br>
//! edge of index index found by the function Perform. <br>
//! There are as many edges in the list as there are faces <br>
//! adjacent to this contiguous edge. <br>
//! Exceptions <br>
//! Standard_OutOfRange if: <br>
//! - index is less than 1, or <br>
//! - index is greater than the number of contiguous edges <br>
//!   found by the function Perform on the shapes added to this algorithm. <br>
Standard_EXPORT  const TopTools_ListOfShape& ContigousEdgeCouple(const Standard_Integer index) const;

//! Returns the edge on the initial shape, of which the <br>
//! modified copy contains the edge section. <br>
//! section is coincident with a contiguous edge found by <br>
//! the function Perform. Use the function <br>
//! ContigousEdgeCouple to obtain a valid section. <br>
//! This information is useful for verification purposes, since <br>
//! it provides a means of determining the surface to which <br>
//! the contiguous edge belongs. <br>
//! Exceptions <br>
//! Standard_NoSuchObject if section is not coincident <br>
//! with a contiguous edge. Use the function <br>
//! ContigousEdgeCouple to obtain a valid section. <br>
Standard_EXPORT  const TopoDS_Edge& SectionToBoundary(const TopoDS_Edge& section) const;

//! Gives the number of degenerated shapes <br>
Standard_EXPORT   Standard_Integer NbDegeneratedShapes() const;

//! Gives a degenerated shape <br>
Standard_EXPORT  const TopoDS_Shape& DegeneratedShape(const Standard_Integer index) const;

//! Indicates if a input shape is degenerated <br>
Standard_EXPORT   Standard_Boolean IsDegenerated(const TopoDS_Shape& shape) const;

//! Returns true if the copy of the initial shape shape was <br>
//! modified by the function Perform (i.e. if one or more of <br>
//! its edges was broken down into contiguous and non-contiguous sections). <br>
//! Warning <br>
//! Returns false if shape is not one of the initial shapes <br>
//! added to this algorithm. <br>
Standard_EXPORT   Standard_Boolean IsModified(const TopoDS_Shape& shape) const;

//! Gives a modifieded shape <br>
//! Raises   NoSuchObject if shape has not been modified <br>
Standard_EXPORT  const TopoDS_Shape& Modified(const TopoDS_Shape& shape) const;

//! Dump properties of resulting shape. <br>
Standard_EXPORT   void Dump() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_BRepBuilderAPI_Sewing mySewing;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
