
set env(WOK_ROOTADMDIR) $env(HOME)/wok/wok_entities
source /usr/share/tcltk/wok2.0/wok_Init.tcl

# Copied from /usr/share/tcltk/wok2.0/site/CreateFactory.tcl
proc CreateFactory { HOME_ENTITIES FNAM WSNAM WBNAM IMPORT_DIR } {

    package require Wok
    package require Ms
    global env
    
    if [catch { package require Tclx } TclXHere] {
	puts stderr "Warning : You'll need package TclX to correctly use WOK."
	puts stderr "          Check for variable TCLLIBPATH"
    }
    if [catch { package require Expect } ExpectHere] {
	puts stderr "Warning : You'll need package Expect to use WOK integration package.."
	puts stderr "          Check for variable TCLLIBPATH"
    }
    
    ;#
    set savpwd [pwd]
    
    ;#
    ;# Create factory FNAM and warehouse attached to it
    ;#
    if { ![wokinfo -x ${FNAM}] } {
	puts "Creating the factory : ${FNAM}"
	if ![catch {fcreate -DHome=$HOME_ENTITIES/${FNAM} -d ${FNAM} } astatus ] {
	    wokcd ${FNAM}
	    if { ![wokinfo -x ${FNAM}:BAG] } {
		puts "Creating the WareHouse in $HOME_ENTITIES/${FNAM}/BAG"
		if [ catch {Wcreate -DHome=$HOME_ENTITIES/${FNAM}/BAG -d -DAdm=$HOME_ENTITIES/${FNAM}/BAG/adm BAG } astatus ] {
		    puts $astatus
		    cd $savpwd
		}
	    }
	} else {
	    puts $astatus
	    cd $savpwd
	}
    }
    
    ;#
    ;# Create workshop WSNAM
    ;#
    if { ![wokinfo -x ${FNAM}:${WSNAM}] } {
	puts "Creating the workshop : ${FNAM}:${WSNAM}"
	if ![ catch {screate -DHome=$HOME_ENTITIES/${FNAM}/${WSNAM} -d ${WSNAM} } astatus] {
	    wokcd -PAdm ${FNAM}:${WSNAM} 
	} else {
	    puts $astatus
	    cd $savpwd
	}
    }
    ;#
    ;# Create workbench WBNAM 
    ;#
    if { ![wokinfo -x ${FNAM}:${WSNAM}:${WBNAM}] } {
	puts "Creating the workbench : ${FNAM}:${WSNAM}:${WBNAM}"
	wokcd ${FNAM}:${WSNAM}
	set WBROOT $HOME_ENTITIES/${FNAM}/${WSNAM}/${WBNAM}
	if [ catch {wcreate -DHome=$IMPORT_DIR -d ${WBNAM} } astatus] {
	    puts $astatus
	    cd $savpwd
	    exit
	}
    }
        
    if { "$IMPORT_DIR" != {} } {
	wokcd -PAdm ${FNAM}:${WSNAM}:${WBNAM}
	foreach udl [glob -nocomplain *.UDLIST] {
	    puts "Importing units from module $udl"
	    foreach unit [FileToList $udl] {
		if [ catch { ucreate -[lindex $unit 0] [lindex $unit 1] } astatus] {
		    puts $astatus
		}
	    }
	}
    }
    cd $savpwd
}

proc FileToList { path {emptl 1} } {
    if ![ catch { set id [ open $path r ] } ] {
        set l  {}
        while {[gets $id line] >= 0 } {
            if { $emptl } {
                if { [string length ${line}] != 0 } {
                    lappend l $line
                }
            } else {
                lappend l $line
            }
        }
        close $id
        return $l
    } else {
        return {}
    }
}

proc checkUnit { dir } {
	wokcd $dir
	if [ catch { umake -e obj } ] {
		#  Maybe it was out of sync
		cd ../..
		system git diff inc/* | patch -R -p2
		wokcd $dir
		if [catch {umake -e obj}] {
			exit
		}
	}
}

proc checkPkg { dir } {
	wokcd $dir
	foreach p [FileToList "PACKAGES"] {
		checkUnit $p
	}
}

proc checkToolkit { l } {
	# install headers for all files of this toolkit
	foreach t $l {
		puts "Generate headers for toolkit: $t"
		wokcd $t
		foreach p [FileToList "PACKAGES"] {
			wokcd $p
			if [catch { umake -e obj.inc }] {
				exit
			}
		}
	}
	puts "WOK is buggy on Linux, regenerate distributed files"
	wokcd ros
	system git diff inc/* | patch -R -p2

	# compile
	foreach t $l {
		checkPkg $t
	}
}

# Change /path/to/opencascade/ros to the directory where sources are unpacked
CreateFactory $env(WOK_ROOTADMDIR) OS OCC63 ros /path/to/opencascade/ros

# Ensure that independent submodules are not coupled together
proc checkHeaderExclusive { parent child1 child2 } {
	foreach f [glob -type f [file join "$child1" "*"]] {
		set g [file tail $f]
	       	if [file exists [file join "$child2" $g]] {
			if [file exists [file join "$parent" $g]]==0 {error "File $g"}
		}
	}
}

checkToolkit "TKernel TKMath TKAdvTools"
wokcd ros
file copy "inc" "inc-foundation"

checkToolkit "TKG2d TKG3d TKGeomBase TKBRep TKGeomAlgo TKTopAlgo TKPrim TKBO TKHLR TKMesh TKShHealing TKBool TKXMesh TKFillet TKFeat TKOffset TKSTL TKXSBase TKSTEPBase TKIGES TKSTEPAttr TKSTEP209 TKSTEP"
wokcd ros
file copy "inc" "inc-modeling"

checkToolkit "TKService TKV2d TKV3d TKOpenGl TKMeshVS TKNIS TKVRML"
wokcd ros
# ocaf-lite depends on modeling but not visualization, so adjust
# directories so that we can detect unwanted coupling
file rename "inc" "inc-visualization"
file copy "inc-modeling" "inc"

checkToolkit "TKCDF PTKernel TKLCAF FWOSPlugin TKPShape TKBinL TKXmlL TKTObj TKShapeSchema TKPLCAF TKStdLSchema StdLPlugin BinLPlugin XmlLPlugin"
wokcd ros
file copy "inc" "inc-ocaf-lite"

checkHeaderExclusive "inc-modeling" "inc-visualization" "inc-ocaf-lite"
foreach f [glob -type f [file join "inc-visualization" "*"]] {
	file copy -force $f [file join "inc" [file tail $f]]
}

checkToolkit "TKCAF TKBin TKXml TKBinTObj TKXmlTObj TKPCAF TKStdSchema StdPlugin XmlPlugin BinPlugin BinTObjPlugin XmlTObjPlugin TKXCAF TKXCAFSchema TKXmlXCAF TKBinXCAF TKXDEIGES TKXDESTEP XCAFPlugin XmlXCAFPlugin BinXCAFPlugin"
wokcd ros
file copy "inc" "inc-ocaf"

checkToolkit "TKDraw TKTopTest TKViewerTest TKXSDRAW TKDCAF TKXDEDRAW TKTObjDRAW DRAWEXE"
wokcd ros
file rename "inc" "inc-draw"
file copy "inc-ocaf" "inc"

checkToolkit "TKWOK TKWOKTcl TKTCPPExt TKCDLFront TKCPPExt TKCPPClient TKIDLFront TKCPPJini TKCPPIntExt TKCSFDBSchema WOKSH WOKLibs"
wokcd ros
file copy "inc" "inc-wok"

checkHeaderExclusive "inc-ocaf" "inc-draw" "inc-wok"
foreach f [glob -type f [file join "inc-draw" "*"]] {
	file copy -force $f [file join "inc" [file tail $f]]
}

