/*
 * Decompiled with CFR 0.152.
 */
package org.openbabel;

import org.openbabel.OBGenericData;
import org.openbabel.OBMol;
import org.openbabel.SpaceGroup;
import org.openbabel.matrix3x3;
import org.openbabel.openbabel_javaJNI;
import org.openbabel.vVector3;
import org.openbabel.vector3;

public class OBUnitCell
extends OBGenericData {
    private long swigCPtr;

    protected OBUnitCell(long l, boolean bl) {
        super(openbabel_javaJNI.SWIGOBUnitCellUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(OBUnitCell oBUnitCell) {
        return oBUnitCell == null ? 0L : oBUnitCell.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            openbabel_javaJNI.delete_OBUnitCell(this.swigCPtr);
        }
        this.swigCPtr = 0L;
        super.delete();
    }

    public OBUnitCell() {
        this(openbabel_javaJNI.new_OBUnitCell__SWIG_0(), true);
    }

    public OBUnitCell(OBUnitCell oBUnitCell) {
        this(openbabel_javaJNI.new_OBUnitCell__SWIG_1(OBUnitCell.getCPtr(oBUnitCell), oBUnitCell), true);
    }

    public void SetData(double d, double d2, double d3, double d4, double d5, double d6) {
        openbabel_javaJNI.OBUnitCell_SetData__SWIG_0(this.swigCPtr, this, d, d2, d3, d4, d5, d6);
    }

    public void SetData(vector3 vector32, vector3 vector33, vector3 vector34) {
        openbabel_javaJNI.OBUnitCell_SetData__SWIG_1(this.swigCPtr, this, vector3.getCPtr(vector32), vector32, vector3.getCPtr(vector33), vector33, vector3.getCPtr(vector34), vector34);
    }

    public void SetOffset(vector3 vector32) {
        openbabel_javaJNI.OBUnitCell_SetOffset(this.swigCPtr, this, vector3.getCPtr(vector32), vector32);
    }

    public void SetSpaceGroup(SpaceGroup spaceGroup) {
        openbabel_javaJNI.OBUnitCell_SetSpaceGroup__SWIG_0(this.swigCPtr, this, SpaceGroup.getCPtr(spaceGroup), spaceGroup);
    }

    public void SetSpaceGroup(String string) {
        openbabel_javaJNI.OBUnitCell_SetSpaceGroup__SWIG_1(this.swigCPtr, this, string);
    }

    public void SetSpaceGroup(int n) {
        openbabel_javaJNI.OBUnitCell_SetSpaceGroup__SWIG_2(this.swigCPtr, this, n);
    }

    public void SetLatticeType(LatticeType latticeType) {
        openbabel_javaJNI.OBUnitCell_SetLatticeType(this.swigCPtr, this, latticeType.swigValue());
    }

    public void FillUnitCell(OBMol oBMol) {
        openbabel_javaJNI.OBUnitCell_FillUnitCell(this.swigCPtr, this, OBMol.getCPtr(oBMol), oBMol);
    }

    public double GetA() {
        return openbabel_javaJNI.OBUnitCell_GetA(this.swigCPtr, this);
    }

    public double GetB() {
        return openbabel_javaJNI.OBUnitCell_GetB(this.swigCPtr, this);
    }

    public double GetC() {
        return openbabel_javaJNI.OBUnitCell_GetC(this.swigCPtr, this);
    }

    public double GetAlpha() {
        return openbabel_javaJNI.OBUnitCell_GetAlpha(this.swigCPtr, this);
    }

    public double GetBeta() {
        return openbabel_javaJNI.OBUnitCell_GetBeta(this.swigCPtr, this);
    }

    public double GetGamma() {
        return openbabel_javaJNI.OBUnitCell_GetGamma(this.swigCPtr, this);
    }

    public vector3 GetOffset() {
        return new vector3(openbabel_javaJNI.OBUnitCell_GetOffset(this.swigCPtr, this), true);
    }

    public SpaceGroup GetSpaceGroup() {
        long l = openbabel_javaJNI.OBUnitCell_GetSpaceGroup(this.swigCPtr, this);
        return l == 0L ? null : new SpaceGroup(l, false);
    }

    public String GetSpaceGroupName() {
        return openbabel_javaJNI.OBUnitCell_GetSpaceGroupName(this.swigCPtr, this);
    }

    public LatticeType GetLatticeType(int n) {
        return LatticeType.swigToEnum(openbabel_javaJNI.OBUnitCell_GetLatticeType__SWIG_0(this.swigCPtr, this, n));
    }

    public LatticeType GetLatticeType() {
        return LatticeType.swigToEnum(openbabel_javaJNI.OBUnitCell_GetLatticeType__SWIG_1(this.swigCPtr, this));
    }

    public vVector3 GetCellVectors() {
        return new vVector3(openbabel_javaJNI.OBUnitCell_GetCellVectors(this.swigCPtr, this), true);
    }

    public matrix3x3 GetCellMatrix() {
        return new matrix3x3(openbabel_javaJNI.OBUnitCell_GetCellMatrix(this.swigCPtr, this), true);
    }

    public matrix3x3 GetOrthoMatrix() {
        return new matrix3x3(openbabel_javaJNI.OBUnitCell_GetOrthoMatrix(this.swigCPtr, this), true);
    }

    public matrix3x3 GetFractionalMatrix() {
        return new matrix3x3(openbabel_javaJNI.OBUnitCell_GetFractionalMatrix(this.swigCPtr, this), true);
    }

    public int GetSpaceGroupNumber(String string) {
        return openbabel_javaJNI.OBUnitCell_GetSpaceGroupNumber__SWIG_0(this.swigCPtr, this, string);
    }

    public int GetSpaceGroupNumber() {
        return openbabel_javaJNI.OBUnitCell_GetSpaceGroupNumber__SWIG_1(this.swigCPtr, this);
    }

    public double GetCellVolume() {
        return openbabel_javaJNI.OBUnitCell_GetCellVolume(this.swigCPtr, this);
    }

    public static final class LatticeType {
        public static final LatticeType Undefined = new LatticeType("Undefined");
        public static final LatticeType Triclinic = new LatticeType("Triclinic");
        public static final LatticeType Monoclinic = new LatticeType("Monoclinic");
        public static final LatticeType Orthorhombic = new LatticeType("Orthorhombic");
        public static final LatticeType Tetragonal = new LatticeType("Tetragonal");
        public static final LatticeType Rhombohedral = new LatticeType("Rhombohedral");
        public static final LatticeType Hexagonal = new LatticeType("Hexagonal");
        public static final LatticeType Cubic = new LatticeType("Cubic");
        private static LatticeType[] swigValues = new LatticeType[]{Undefined, Triclinic, Monoclinic, Orthorhombic, Tetragonal, Rhombohedral, Hexagonal, Cubic};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static LatticeType swigToEnum(int n) {
            if (n < swigValues.length && n >= 0 && LatticeType.swigValues[n].swigValue == n) {
                return swigValues[n];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (LatticeType.swigValues[i].swigValue != n) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + LatticeType.class + " with value " + n);
        }

        private LatticeType(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private LatticeType(String string, int n) {
            this.swigName = string;
            this.swigValue = n;
            swigNext = n + 1;
        }

        private LatticeType(String string, LatticeType latticeType) {
            this.swigName = string;
            this.swigValue = latticeType.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

