/*
// This software is subject to the terms of the Eclipse Public License v1.0
// Agreement, available at the following URL:
// http://www.eclipse.org/legal/epl-v10.html.
// Copyright (C) 2007-2009 Julian Hyde
// All Rights Reserved.
// You must accept the terms of that agreement to use this software.
*/
package org.olap4j.driver.xmla;

import org.olap4j.*;

import java.util.*;

/**
 * Implementation of {@link org.olap4j.CellSetAxis}
 * for XML/A providers.
 *
 * @author jhyde
 * @version $Id: XmlaOlap4jCellSetAxis.java 229 2009-05-08 19:11:29Z jhyde $
 * @since Dec 5, 2007
 */
class XmlaOlap4jCellSetAxis implements CellSetAxis {
    private final XmlaOlap4jCellSet olap4jCellSet;
    private final Axis axis;
    final List<Position> positions = new ArrayList<Position>();
    private final List<Position> immutablePositions =
        Collections.unmodifiableList(positions);

    /**
     * Creates an XmlaOlap4jCellSetAxis.
     *
     * @param olap4jCellSet Cell set
     * @param axis Axis identifier
     */
    public XmlaOlap4jCellSetAxis(
        XmlaOlap4jCellSet olap4jCellSet,
        Axis axis)
    {
        this.olap4jCellSet = olap4jCellSet;
        this.axis = axis;
    }

    public Axis getAxisOrdinal() {
        return axis;
    }

    public CellSet getCellSet() {
        return olap4jCellSet;
    }

    public CellSetAxisMetaData getAxisMetaData() {
        final CellSetMetaData cellSetMetaData = olap4jCellSet.getMetaData();
        if (axis.isFilter()) {
            return cellSetMetaData.getFilterAxisMetaData();
        } else {
            return cellSetMetaData.getAxesMetaData().get(
                axis.axisOrdinal());
        }
    }

    public List<Position> getPositions() {
        return immutablePositions;
    }

    public int getPositionCount() {
        return positions.size();
    }

    public ListIterator<Position> iterator() {
        return immutablePositions.listIterator();
    }
}

// End XmlaOlap4jCellSetAxis.java
