

%  This example demonstrates the use of the contour filter, and the use of
%  the vtkSampleFunction to generate a volume of data samples 
%  implicit function.

vtk_init;

%  VTK supports implicit functions of the form f(x,y,z)=constant. These 
%  functions can represent things spheres, cones, etc. Here we use a 
%  general form for a quadric to create an elliptical data field.
quadric = vtkQuadric();
quadric.SetCoefficients(.5, 1, .2, 0, .1, 0, 0, .2, 0, 0);

%  vtkSampleFunction samples an implicit function over the x-y-z range
%  specified (here it defaults to -1,1 in the x,y,z directions).
sample = vtkSampleFunction();
sample.SetSampleDimensions(30, 30, 30);
sample.SetImplicitFunction(quadric);

%  Create five surfaces F(x,y,z) = constant between range specified. The
%  GenerateValues() method creates n isocontour values between the range
%  specified.
contours = vtkContourFilter();
contours.SetInput(sample.GetOutput());
contours.GenerateValues(5, 0.0, 1.2);

contMapper = vtkPolyDataMapper();
contMapper.SetInput(contours.GetOutput());
contMapper.SetScalarRange(0.0, 1.2);

contActor = vtkActor();
contActor.SetMapper(contMapper);

%  We'll put a simple outline around the data.
outline = vtkOutlineFilter();
outline.SetInput(sample.GetOutput());

outlineMapper = vtkPolyDataMapper();
outlineMapper.SetInput(outline.GetOutput());

outlineActor = vtkActor();
outlineActor.SetMapper(outlineMapper);
outlineActor.GetProperty().SetColor(0,0,0);

%  The usual rendering stuff.
ren = vtkRenderer();
renWin = vtkRenderWindow();
renWin.AddRenderer(ren);
iren = vtkRenderWindowInteractor();
iren.SetRenderWindow(renWin);

ren.SetBackground(1, 1, 1);
ren.AddActor(contActor);
ren.AddActor(outlineActor);


% renWin.Render();
vtkInitializeInteractor(iren);
