% This example demonstrates the use of 2D text.

vtk_init

% Create a sphere source, mapper, and actor
sphere = vtkSphereSource()

sphereMapper = vtkPolyDataMapper()
sphereMapper.SetInput(sphere.GetOutput())
sphereMapper.GlobalImmediateModeRenderingOn()
sphereActor = vtkLODActor()
sphereActor.SetMapper(sphereMapper)

% Create a scaled text actor. 
% Set the text, font, justification, and properties (bold, italics,
% etc.).
textActor = vtkTextActor()
textActor.ScaledTextOn()
textActor.SetDisplayPosition(90, 50)
textActor.SetInput("This is a sphere")

% Set coordinates to match the old vtkScaledTextActor default value
textActor.GetPosition2Coordinate().SetCoordinateSystemToNormalizedViewport()
textActor.GetPosition2Coordinate().SetValue(0.6, 0.1)

tprop = textActor.GetTextProperty()
tprop.SetFontSize(18)
tprop.SetFontFamilyToArial()
tprop.SetJustificationToCentered()
tprop.BoldOn()
tprop.ItalicOn()
tprop.ShadowOn()
tprop.SetColor(0, 0, 1)


f = vtk_figure(0);
% Create graphics stuff;
ren = f.renderer;

% Add the actors to the renderer; set the background and size; zoom
% in; and render.
ren.AddActor2D(textActor)
ren.AddActor(sphereActor)

ren.SetBackground(1, 1, 1)
ren.GetActiveCamera().Zoom(1.5)

