%%NAME
%%  ehtmladdimg  -  add PNG- or JPEG-file to exist html file
%%
%%SYNOPSIS
%%  ehtmladdimg(htmlFileName,imgFileName)
%%
%%PARAMETER(S)
%%  htmlFileName   name of html-file
%%  imgFileName    name of PNG- or JPEG-file
%%GLOBAL PARAMETER(S)
% written by stefan.mueller@fhr.fraunhofer.de (C) 2010
function [htmlFileName]=ehtmladdimg(htmlFileName,imgFileName)
  if (nargin<2)||(nargin>2)
    eusage('ehtmladdimg(htmlFileName,imgFileName)');
  end
  if exist(imgFileName)~=2
    disp('error in ehtmladdimg: file not exist');
  else
    htmlFile=fopen(htmlFileName,'r+b');
    if htmlFile<=0
      disp('error in ehtmladdimg: file not exist');
    else
      ifl=length(imgFileName);
      if '.png'==imgFileName(ifl-3:ifl)
       mime='image/png';
      else
       mime='image/jpeg';
      end
      fid=fopen(imgFileName,'rb');
      [imgString n]=fread(fid,inf,'uchar');
      fclose(fid);
      [code codeL]=evec2b64(imgString);
      trans='ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
      codeC=trans(code+1);
      % add image to html file
      fseek(htmlFile,-30,1);
      [data dl]=fread(htmlFile,inf,'uchar');
      htmlText=char(data);
      pos=findstr(htmlText,'</CENTER></BODY>')-1;
      fseek(htmlFile,-30,1);
      fwrite(htmlFile,data(1:pos),'uchar');
      fprintf(htmlFile,'<IMG src=\"data:%s;base64,%s\">\n',mime,codeC);
      fprintf(htmlFile,'</CENTER></BODY>\n<HTML>\n');
      fclose(htmlFile);
    end
  end
