#ifndef _DIRLIST_H
#define _DIRLIST_H

#include "config.h"
#if 0
#include <dirent.h>
#include <sys/types.h>
#endif
#include <stdio.h> /* size_t */

struct dmDrive;
struct modlistentry
{
	char shortname[12]; /* the name that we present in the filelists.. 8:3 format looks so nice... yuck... but i works*/
	const struct dmDrive *drive;
//	char fullname[PATH_MAX+1]; /* the very full path to this object */
	uint32_t dirdbfullpath; /* full path */
	char name[NAME_MAX+1]; /* the very lonely filename */
	
#define MODLIST_FLAG_DIR      1
#define MODLIST_FLAG_ARC      2 /* mutual exlusive flags, but we still let them have bit values.. looks nice */
#define MODLIST_FLAG_FILE     4
#define MODLIST_FLAG_VIRTUAL  8
#define MODLIST_FLAG_DRV      16
	int flags;
	uint32_t fileref;
	/* uint32_t dirref; */
	uint32_t adb_ref; /* new, until dirref is re-created later perhaps */

	int (*Read)(struct modlistentry *entry, char **mem, size_t *size);
	int (*ReadHeader)(struct modlistentry *entry, char *mem, size_t *size); /* size is prefilled with max data, and mem is preset*/
	FILE *(*ReadHandle)(struct modlistentry *entry);
};

struct modlist
{
	struct modlistentry **files;
	struct modlistentry **realfiles;

	/* these are used by external */
	int pos; /* position */

	int max; /* current array size */
	int num; /* entries used */

	void (*_free)(struct modlist *);
	struct modlistentry *(*getcur)(const struct modlist *modlist); /* does not Ref() */
	struct modlistentry *(*get)(const struct modlist *modlist, int index);
	void (*append)(struct modlist *modlist, struct modlistentry *entry);
	void (*remove)(struct modlist *modlist, int index, int count);
	int (*find)(struct modlist *modlist, const uint32_t path);
	void (*sort)(struct modlist *modlist);
	int (*fuzzyfind)(struct modlist *modlist, const char *filename);
};

extern void sort_modlist(struct modlist *modlist);
extern struct modlist *create_modlist(void);

extern void fs12name(char *dst13bytes, const char *source);

#endif
