// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _math_BracketedRoot_HeaderFile
#define _math_BracketedRoot_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class StdFail_NotDone;
class math_Function;


//! This class implements the Brent method to find the root of a function <br>
//! located within two bounds. No knowledge of the derivative is required. <br>
class math_BracketedRoot  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
//! The Brent method is used to find the root of the function F between <br>
//! the bounds Bound1 and Bound2 on the function F. <br>
//! If F(Bound1)*F(Bound2) >0 the Brent method fails. <br>
//! The tolerance required for the root is given by Tolerance. <br>
//! The solution is found when : <br>
//!    abs(Xi - Xi-1) <= Tolerance; <br>
//! The maximum number of iterations allowed is given by NbIterations. <br>
  Standard_EXPORT   math_BracketedRoot(math_Function& F,const Standard_Real Bound1,const Standard_Real Bound2,const Standard_Real Tolerance,const Standard_Integer NbIterations = 100,const Standard_Real ZEPS = 1.0e-12);
  //! Returns true if the computations are successful, otherwise returns false. <br>
        Standard_Boolean IsDone() const;
  //! returns the value of the root. <br>
//! Exception NotDone is raised if the minimum was not found. <br>
        Standard_Real Root() const;
  //! returns the value of the function at the root. <br>
//! Exception NotDone is raised if the minimum was not found. <br>
        Standard_Real Value() const;
  //! returns the number of iterations really done during the <br>
//! computation of the Root. <br>
//! Exception NotDone is raised if the minimum was not found. <br>
        Standard_Integer NbIterations() const;
  //! Prints on the stream o information on the current state <br>
//!          of the object. <br>
  Standard_EXPORT     void Dump(Standard_OStream& o) const;





protected:





private:



Standard_Boolean Done;
Standard_Real TheRoot;
Standard_Real TheError;
Standard_Integer NbIter;


};


#include <math_BracketedRoot.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
