// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _AIS_TexturedShape_HeaderFile
#define _AIS_TexturedShape_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_AIS_TexturedShape_HeaderFile
#include <Handle_AIS_TexturedShape.hxx>
#endif

#ifndef _Graphic3d_NameOfTexture2D_HeaderFile
#include <Graphic3d_NameOfTexture2D.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Graphic3d_AspectFillArea3d_HeaderFile
#include <Handle_Graphic3d_AspectFillArea3d.hxx>
#endif
#ifndef _Handle_Graphic3d_Texture2Dmanual_HeaderFile
#include <Handle_Graphic3d_Texture2Dmanual.hxx>
#endif
#ifndef _AIS_Shape_HeaderFile
#include <AIS_Shape.hxx>
#endif
#ifndef _Handle_PrsMgr_PresentationManager3d_HeaderFile
#include <Handle_PrsMgr_PresentationManager3d.hxx>
#endif
#ifndef _Handle_Prs3d_Presentation_HeaderFile
#include <Handle_Prs3d_Presentation.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
class Graphic3d_AspectFillArea3d;
class Graphic3d_Texture2Dmanual;
class TopoDS_Shape;
class TCollection_AsciiString;
class PrsMgr_PresentationManager3d;
class Prs3d_Presentation;
class gp_Pnt;


//! This class allows to map textures on shapes <br>
//!  Textures are image files. <br>
//!   The texture itself is parametrized in (0,1)x(0,1). <br>
//!  Each face of a shape located in <br>
//! UV space is provided with these parameters: <br>
//!    -      Umin - starting position in U <br>
//!    -      Umax - ending position in U <br>
//!    -      Vmin - starting position in V <br>
//!    -      Vmax - ending position in V <br>
//!  Each face is triangulated and a texel is assigned to each <br>
//!  node. Facets are then filled using a linear interpolation <br>
//!  of texture between each 'three texels' <br>
//!  User can act on : <br>
//!  - the number of occurences of the texture on the face <br>
//!  - the position of the origin of the texture <br>
//!  - the scale factor of the texture <br>
class AIS_TexturedShape : public AIS_Shape {

public:

  //!      Initializes the textured shape ashape. <br>
  Standard_EXPORT   AIS_TexturedShape(const TopoDS_Shape& shap);
  //! Sets the name of the texture file to map. The accepted <br>
//!      file types are those used in AlienImage with extensions <br>
//!      such as xwd, bmp, gif, rgb, ras, rs and more. <br>
  Standard_EXPORT   virtual  void SetTextureFileName(const TCollection_AsciiString& TextureFileName) ;
  //! Sets the number of occurrences of <br>
//! the texture on each face. The texture itself is parameterized <br>
//! in (0,1) by (0,1) . Each face of the shape to be textured is <br>
//! parameterized in UV space (Umin,Umax) by (Vmin,Vmax). If <br>
//! RepeatYN is set to false, texture coordinates are clamped in the <br>
//! range (0,1)x(0,1) of the face. <br>
  Standard_EXPORT   virtual  void SetTextureRepeat(const Standard_Boolean RepeatYN,const Standard_Real URepeat = 1.0,const Standard_Real VRepeat = 1.0) ;
  //! Use this method to change the origin of the <br>
//!         texture. The texel (0,0) will be mapped to the <br>
//!         surfel (UOrigin,VOrigin) <br>
  Standard_EXPORT   virtual  void SetTextureOrigin(const Standard_Boolean SetTextureOriginYN,const Standard_Real UOrigin = 0.0,const Standard_Real VOrigin = 0.0) ;
  //! Use this method to scale the texture (percent of <br>
//!         the face). <br>
//!         You can specify a scale factor for both U and V. <br>
//! <br>
//!         example : if you set ScaleU and ScaleV to 0.5 and <br>
//!         you enable texture repeat, the texture will appear <br>
//!         twice on the face in each direction. <br>
  Standard_EXPORT   virtual  void SetTextureScale(const Standard_Boolean SetTextureScaleYN,const Standard_Real ScaleU = 1.0,const Standard_Real ScaleV = 1.0) ;
  //! Use this method to show the triangulation of <br>
//!         the shape. This is not very esthetic but can be <br>
//!         usefull for debug ... <br>
  Standard_EXPORT   virtual  void ShowTriangles(const Standard_Boolean ShowTrianglesYN = Standard_False) ;
  //! Enables texture mapping <br>
  Standard_EXPORT     void SetTextureMapOn() ;
  //! Disables texture mapping <br>
  Standard_EXPORT     void SetTextureMapOff() ;
  //! Enables texture modulation <br>
  Standard_EXPORT     void EnableTextureModulate() ;
  //! Disables texture modulation <br>
  Standard_EXPORT     void DisableTextureModulate() ;
  //! Use this method to display the textured shape <br>
//!         without recomputing the whole presentation. <br>
//!         Use this method when ONLY the texture has been changed. <br>
//!         ie : myTShape->UpdateAttributes() <br>
//! <br>
//!         If other parameters (ie: scale factors, <br>
//!         texture origin, texture repeat ...) have changed, <br>
//!         the whole presentation has to be recomputed. <br>
//!         ie : if (myShape->DisplayMode() == 3) <br>
//!	    	       myAISContext->RecomputePrsOnly(myShape); <br>
//!	    	    else <br>
//!	    	       { <br>
//!	    	         myAISContext->SetDisplayMode(myShape,3,Standard_False); <br>
//!	                 myAISContext->Display(myShape, Standard_True); <br>
//!	               } <br>
  Standard_EXPORT     void UpdateAttributes() ;
  
  Standard_EXPORT     Standard_Boolean TextureMapState() const;
  
  Standard_EXPORT     Standard_Real URepeat() const;
  
  Standard_EXPORT     Standard_Boolean TextureRepeat() const;
  
  Standard_EXPORT     Standard_Real Deflection() const;
  
  Standard_EXPORT     Standard_CString TextureFile() const;
  
  Standard_EXPORT     Standard_Real VRepeat() const;
  
  Standard_EXPORT     Standard_Boolean ShowTriangles() const;
  
  Standard_EXPORT     Standard_Real TextureUOrigin() const;
  
  Standard_EXPORT     Standard_Real TextureVOrigin() const;
  
  Standard_EXPORT     Standard_Real TextureScaleU() const;
  
  Standard_EXPORT     Standard_Real TextureScaleV() const;
  
  Standard_EXPORT     Standard_Boolean TextureScale() const;
  
  Standard_EXPORT     Standard_Boolean TextureOrigin() const;
  
  Standard_EXPORT     Standard_Boolean TextureModulate() const;




  DEFINE_STANDARD_RTTI(AIS_TexturedShape)

protected:

  
  Standard_EXPORT   virtual  void Compute(const Handle(PrsMgr_PresentationManager3d)& aPresentationManager,const Handle(Prs3d_Presentation)& aPresentation,const Standard_Integer aMode = 0) ;



private: 

  
  Standard_EXPORT     Standard_Boolean TriangleIsValid(const gp_Pnt& P1,const gp_Pnt& P2,const gp_Pnt& P3) const;

Graphic3d_NameOfTexture2D myPredefTexture;
TCollection_AsciiString myTextureFile;
Standard_Boolean DoRepeat;
Standard_Real myURepeat;
Standard_Real myVRepeat;
Standard_Boolean DoMapTexture;
Standard_Boolean DoSetTextureOrigin;
Standard_Real myUOrigin;
Standard_Real myVOrigin;
Standard_Boolean DoSetTextureScale;
Standard_Real myScaleU;
Standard_Real myScaleV;
Standard_Boolean DoShowTriangles;
Standard_Real myDeflection;
Handle_Graphic3d_AspectFillArea3d myAspect;
Handle_Graphic3d_Texture2Dmanual mytexture;
Standard_Real Umin;
Standard_Real Umax;
Standard_Real Vmin;
Standard_Real Vmax;
Standard_Real dUmax;
Standard_Real dVmax;
Standard_Boolean myModulate;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
