// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Geom2dGcc_Circ2d2TanRad_HeaderFile
#define _Geom2dGcc_Circ2d2TanRad_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TColgp_Array1OfCirc2d_HeaderFile
#include <TColgp_Array1OfCirc2d.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _GccEnt_Array1OfPosition_HeaderFile
#include <GccEnt_Array1OfPosition.hxx>
#endif
#ifndef _TColStd_Array1OfInteger_HeaderFile
#include <TColStd_Array1OfInteger.hxx>
#endif
#ifndef _TColgp_Array1OfPnt2d_HeaderFile
#include <TColgp_Array1OfPnt2d.hxx>
#endif
#ifndef _TColStd_Array1OfReal_HeaderFile
#include <TColStd_Array1OfReal.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Geom2d_Point_HeaderFile
#include <Handle_Geom2d_Point.hxx>
#endif
#ifndef _GccEnt_Position_HeaderFile
#include <GccEnt_Position.hxx>
#endif
class Standard_OutOfRange;
class GccEnt_BadQualifier;
class StdFail_NotDone;
class Standard_NegativeValue;
class Geom2dGcc_QualifiedCurve;
class Geom2d_Point;
class GccAna_Circ2d2TanRad;
class Geom2dGcc_MyCirc2d2TanRad;
class gp_Circ2d;
class gp_Pnt2d;


//! This class implements the algorithms used to <br>
//!          create 2d circles tangent to one curve and a <br>
//!          point/line/circle/curv and with a given radius. <br>
//!          For each construction methods arguments are: <br>
//!            - Two Qualified elements for tangency constrains. <br>
//!            (for example EnclosedCirc if we want the <br>
//!            solution inside the argument EnclosedCirc). <br>
//!            - Two Reals. One (Radius) for the radius and the <br>
//!            other (Tolerance) for the tolerance. <br>
//!          Tolerance is only used for the limit cases. <br>
//!          For example : <br>
//!          We want to create a circle inside a circle C1 and <br>
//!          inside a curve Cu2 with a radius Radius and a <br>
//!          tolerance Tolerance. <br>
//!          If we did not used Tolerance it is impossible to <br>
//!          find a solution in the the following case : Cu2 is <br>
//!          inside C1 and there is no intersection point <br>
//!          between the two elements. <br>
//!          with Tolerance we will give a solution if the <br>
//!          lowest distance between C1 and Cu2 is lower than or <br>
//!          equal Tolerance. <br>
class Geom2dGcc_Circ2d2TanRad  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
  Standard_EXPORT   Geom2dGcc_Circ2d2TanRad(const Geom2dGcc_QualifiedCurve& Qualified1,const Geom2dGcc_QualifiedCurve& Qualified2,const Standard_Real Radius,const Standard_Real Tolerance);
  
  Standard_EXPORT   Geom2dGcc_Circ2d2TanRad(const Geom2dGcc_QualifiedCurve& Qualified1,const Handle(Geom2d_Point)& Point,const Standard_Real Radius,const Standard_Real Tolerance);
  //! These constructors create one or more 2D circles of radius Radius either <br>
//! -   tangential to the 2 curves Qualified1 and Qualified2,   or <br>
//! -   tangential to the curve Qualified1 and passing through the point Point, or <br>
//! -   passing through two points Point1 and Point2. <br>
//! Tolerance is a tolerance criterion used by the algorithm <br>
//! to find a solution when, mathematically, the problem <br>
//! posed does not have a solution, but where there is <br>
//! numeric uncertainty attached to the arguments. <br>
//! For example, take two circles C1 and C2, such that C2 <br>
//! is inside C1, and almost tangential to C1. There is, in <br>
//! fact, no point of intersection between C1 and C2. You <br>
//! now want to find a circle of radius R (smaller than the <br>
//! radius of C2), which is tangential to C1 and C2, and <br>
//! inside these two circles: a pure mathematical resolution <br>
//! will not find a solution. This is where the tolerance <br>
//! criterion is used: the algorithm considers that C1 and <br>
//! C2 are tangential if the shortest distance between these <br>
//! two circles is less than or equal to Tolerance. Thus, a <br>
//! solution is found by the algorithm. <br>
//! Exceptions <br>
//! GccEnt_BadQualifier if a qualifier is inconsistent with <br>
//! the argument it qualifies (for example, enclosing for a line). <br>
//! Standard_NegativeValue if Radius is negative. <br>
  Standard_EXPORT   Geom2dGcc_Circ2d2TanRad(const Handle(Geom2d_Point)& Point1,const Handle(Geom2d_Point)& Point2,const Standard_Real Radius,const Standard_Real Tolerance);
  
  Standard_EXPORT     void Results(const GccAna_Circ2d2TanRad& Circ) ;
  
  Standard_EXPORT     void Results(const Geom2dGcc_MyCirc2d2TanRad& Circ) ;
  //! This method returns True if the algorithm succeeded. <br>
//! Note: IsDone protects against a failure arising from a <br>
//! more internal intersection algorithm, which has reached its numeric limits. <br>
  Standard_EXPORT     Standard_Boolean IsDone() const;
  //! This method returns the number of solutions. <br>
//!          NotDone is raised if the algorithm failed. <br>
//! Exceptions <br>
//! StdFail_NotDone if the construction fails. <br>
  Standard_EXPORT     Standard_Integer NbSolutions() const;
  //! Returns the solution number Index and raises OutOfRange <br>
//! exception if Index is greater than the number of solutions. <br>
//! Be carefull: the Index is only a way to get all the <br>
//! solutions, but is not associated to theses outside the context of the algorithm-object. <br>
//! Warning <br>
//! This indexing simply provides a means of consulting the <br>
//! solutions. The index values are not associated with <br>
//! these solutions outside the context of the algorithm object. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is less than zero or <br>
//! greater than the number of solutions computed by this algorithm. <br>
//! StdFail_NotDone if the construction fails. <br>
  Standard_EXPORT     gp_Circ2d ThisSolution(const Standard_Integer Index) const;
  //! Returns the qualifiers Qualif1 and Qualif2 of the <br>
//! tangency arguments for the solution of index Index <br>
//! computed by this algorithm. <br>
//! The returned qualifiers are: <br>
//! -   those specified at the start of construction when the <br>
//!   solutions are defined as enclosed, enclosing or <br>
//!   outside with respect to the arguments, or <br>
//! -   those computed during construction (i.e. enclosed, <br>
//!   enclosing or outside) when the solutions are defined <br>
//!   as unqualified with respect to the arguments, or <br>
//! -   GccEnt_noqualifier if the tangency argument is a point, or <br>
//! -   GccEnt_unqualified in certain limit cases where it <br>
//!   is impossible to qualify the solution as enclosed, enclosing or outside. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is less than zero or <br>
//! greater than the number of solutions computed by this algorithm. <br>
//! StdFail_NotDone if the construction fails. <br>
  Standard_EXPORT     void WhichQualifier(const Standard_Integer Index,GccEnt_Position& Qualif1,GccEnt_Position& Qualif2) const;
  //! Returns informations about the tangency point between the <br>
//! result number Index and the first argument. <br>
//! ParSol is the intrinsic parameter of the point PntSol on the solution curv. <br>
//! ParArg is the intrinsic parameter of the point PntSol on the argument curv. <br>
//! OutOfRange is raised if Index is greater than the number of solutions. <br>
//! notDone is raised if the construction algorithm did not succeed. <br>
  Standard_EXPORT     void Tangency1(const Standard_Integer Index,Standard_Real& ParSol,Standard_Real& ParArg,gp_Pnt2d& PntSol) const;
  //! Returns informations about the tangency point between the <br>
//! result number Index and the second argument. <br>
//! ParSol is the intrinsic parameter of the point PntSol on the solution curv. <br>
//! ParArg is the intrinsic parameter of the point PntSol on the argument curv. <br>
//! OutOfRange is raised if Index is greater than the number of solutions. <br>
//! notDone is raised if the construction algorithm did not succeed. <br>
  Standard_EXPORT     void Tangency2(const Standard_Integer Index,Standard_Real& ParSol,Standard_Real& ParArg,gp_Pnt2d& PntSol) const;
  //! Returns true if the solution of index Index and, <br>
//! respectively, the first or second argument of this <br>
//! algorithm are the same (i.e. there are 2 identical circles). <br>
//! If Rarg is the radius of the first or second argument, <br>
//! Rsol is the radius of the solution and dist is the <br>
//! distance between the two centers, we consider the two <br>
//! circles to be identical if |Rarg - Rsol| and dist <br>
//! are less than or equal to the tolerance criterion given at <br>
//! the time of construction of this algorithm. <br>
//! OutOfRange is raised if Index is greater than the number of solutions. <br>
//! notDone is raised if the construction algorithm did not succeed. <br>
  Standard_EXPORT     Standard_Boolean IsTheSame1(const Standard_Integer Index) const;
  //! Returns true if the solution of index Index and, <br>
//! respectively, the first or second argument of this <br>
//! algorithm are the same (i.e. there are 2 identical circles). <br>
//! If Rarg is the radius of the first or second argument, <br>
//! Rsol is the radius of the solution and dist is the <br>
//! distance between the two centers, we consider the two <br>
//! circles to be identical if |Rarg - Rsol| and dist <br>
//! are less than or equal to the tolerance criterion given at <br>
//! the time of construction of this algorithm. <br>
//! OutOfRange is raised if Index is greater than the number of solutions. <br>
//! notDone is raised if the construction algorithm did not succeed. <br>
  Standard_EXPORT     Standard_Boolean IsTheSame2(const Standard_Integer Index) const;





protected:





private:



Standard_Boolean WellDone;
TColgp_Array1OfCirc2d cirsol;
Standard_Integer NbrSol;
GccEnt_Array1OfPosition qualifier1;
GccEnt_Array1OfPosition qualifier2;
TColStd_Array1OfInteger TheSame1;
TColStd_Array1OfInteger TheSame2;
TColgp_Array1OfPnt2d pnttg1sol;
TColgp_Array1OfPnt2d pnttg2sol;
TColStd_Array1OfReal par1sol;
TColStd_Array1OfReal par2sol;
TColStd_Array1OfReal pararg1;
TColStd_Array1OfReal pararg2;
Standard_Boolean Invert;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
