/* -*- Mode: C; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2007-2008 Tadas Dailyda <tadas@dailyda.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __ODS_OBEX_H
#define __ODS_OBEX_H

#include <glib.h>

#define CONID_INVALID 0xFFFFFFFF

#define ODS_OBEX_RX_MTU 4096
#define ODS_OBEX_TX_MTU 32767

#define CAP_TYPE "x-obex/capability"
#define OBP_TYPE "x-obex/object-profile"
#define LST_TYPE "x-obex/folder-listing"

typedef struct 
{
	obex_t			*obex_handle;
	guint16			tx_max;
	guint16			rx_max;
	guint32			connection_id;
	
	/* transfer basic info */
	guint8			obex_cmd; /* either PUT or GET */
	gchar			*local; 
	gchar			*remote;
	gchar			*type;
	guint64			target_size;
	time_t			modtime;
	gboolean		report_progress;
	gboolean		transfer_started_signal_emitted;
	gboolean		suspended_once; /* convenience variable for server sessions */
	/* transfer data */
	guchar			*buf;	/* Data buffer for put and get requests */
	guint64			buf_size;
	gint			stream_fd;
	/* transfer status */
	guint64			counter;
	
} OdsObexContext;

typedef struct obex_connect_hdr {
    uint8_t  version;
    uint8_t  flags;
    uint16_t mtu;
} __attribute__ ((packed)) obex_connect_hdr_t;

typedef struct obex_setpath_hdr {
    uint8_t  flags;
    uint8_t constants;
} __attribute__ ((packed)) obex_setpath_hdr_t;


void		ods_obex_transfer_new (OdsObexContext *obex_context,
											const gchar *local,
											const gchar *remote,
											const gchar *type);
void		ods_obex_transfer_close	(OdsObexContext *obex_context);
OdsObexContext *ods_obex_context_new (void);
gchar		*ods_obex_get_buffer_as_string (OdsObexContext *obex_context);
gboolean	ods_obex_srv_new_file (OdsObexContext *obex_context,
											const gchar *path);
gint		ods_obex_connect_done (OdsObexContext *obex_context, 
											obex_object_t *object);
gint		ods_obex_connect	(OdsObexContext *obex_context, 
											const guchar *uuid, 
											guint uuid_length);
gint		ods_obex_srv_connect (OdsObexContext *obex_context,
											obex_object_t *object,
											guint service);
gint		ods_obex_disconnect	(OdsObexContext *obex_context);
gint		ods_obex_readstream	(OdsObexContext *obex_context, 
											obex_object_t *object);
gint		ods_obex_writestream(OdsObexContext *obex_context,
											obex_object_t *object);
gint		ods_obex_get		(OdsObexContext *obex_context,
											const gchar *local,
											const gchar *remote,
											const gchar *type);
gint		ods_obex_srv_get	(OdsObexContext *obex_context,
											obex_object_t *object,
											const gchar *current_path,
											const gchar *root_path,
											gboolean allow_write);
gint		ods_obex_put		(OdsObexContext *obex_context,
											const gchar *local, 
											const gchar *remote, 
											const gchar *type);
gint		ods_obex_srv_put	(OdsObexContext *obex_context,
											obex_object_t *object,
											const gchar *path);
gint		ods_obex_setpath	(OdsObexContext *obex_context, 
											const gchar *path,
											gboolean create);
gboolean	ods_obex_srv_setpath (OdsObexContext *obex_context,
											obex_object_t *object,
											const gchar *root_path,
											const gchar *current_path,
											gchar **new_path);

#endif /* __ODS_OBEX_H */
