/*
   start_wdog.c: a sample program for using the hardware Watchdog
   Copyright 1998, 2000  woody@netwinder.org

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>

int 
main (int argc, const char *argv[])
{
	int fd = open ("/dev/watchdog", O_WRONLY);

	if (fd == -1)
	{
		fprintf (stderr, "/dev/watchdog could not be opened.");
		fprintf (stderr, "Please make sure that the watchdog module is loaded");
		fprintf (stderr, "and \"/dev/watchdog c 10 130\" is writeable.");
		exit (1);
	}

	while (1)
	{
		write (fd, "\5", 1);
		fsync (fd);
		sleep (30);		//kick WD every 30 seconds
	}
}
