#!/usr/bin/perl
#
# $Id: UDPPacket.pm,v 1.4 2001/10/06 22:19:14 levine Exp $
#
# Copyright (C) 2001  James D. Levine (jdl@vinecorp.com)
#
#
#   This program is free software; you can redistribute it and/or
#   modify it under the terms of the GNU General Public License
#   as published by the Free Software Foundation; either version 2
#   of the License, or (at your option) any later version.
# 
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
# 
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
#   02111-1307, USA.
#
####################################################################

use NWatch::Packet;
use strict;


####################################################################
#
# udp_packet
#
# Decodes udp fields.
#
####################################################################



package NWatch::udp_packet;

@NWatch::udp_packet::ISA = qw( NWatch::packet );

sub protocol_name { "udp"; }

sub new
{
    my( $classtype, $data ) = @_;

    # init from base class
    my $self = NWatch::packet::new( $classtype, $data );


    # unpack fields

    my( $source_port, $destination_port, $length, $checksum ) = unpack "nnnn", $data;

#    print "udp_packet: entry \n";

    $self->set( "source_port",       $source_port );
    $self->set( "destination_port",  $destination_port );
    $self->set( "length",  $length );
    $self->set( "checksum",  $checksum );

    $self->set( "payload", substr( $data, 9, length( $data ) -9 ) ) if length( $data ) > 8;

#    print "udp source $source_port dest $destination_port length $length checksum $checksum \n";
	    
    $self;
}


1;
