// file kernel/n/alpha/dumpreg.S: debugging facilities
/*-----------------------------------------------------------------------+
 |  Copyright 2005-2006, Michel Quercia (michel.quercia@prepas.org)      |
 |                                                                       |
 |  This file is part of Numerix. Numerix is free software; you can      |
 |  redistribute it and/or modify it under the terms of the GNU Lesser   |
 |  General Public License as published by the Free Software Foundation; |
 |  either version 2.1 of the License, or (at your option) any later     |
 |  version.                                                             |
 |                                                                       |
 |  The Numerix Library is distributed in the hope that it will be       |
 |  useful, but WITHOUT ANY WARRANTY; without even the implied warranty  |
 |  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  |
 |  Lesser General Public License for more details.                      |
 |                                                                       |
 |  You should have received a copy of the GNU Lesser General Public     |
 |  License along with the GNU MP Library; see the file COPYING. If not, |
 |  write to the Free Software Foundation, Inc., 59 Temple Place -       |
 |  Suite 330, Boston, MA 02111-1307, USA.                               |
 +-----------------------------------------------------------------------+
 |                                                                       |
 |                    Affichage des registres alpha                      |
 |                                                                       |
 +-----------------------------------------------------------------------*/

                        # +---------------------------+
                        # |  Affichage d un registre  |
                        # +---------------------------+

#define DUMPREG(x) \
	lda  $30,-16($30) ;\
	stq  $16,  0($30) ;\
	stq  $26,  8($30) ;\
	lda  $16,  x($31) ;\
	bsr  $26,  sn_dumpreg ;\
	ldq  $16,  0($30) ;\
	ldq  $26,  8($30) ;\
	lda  $30, 16($30)

	.align 5
	.globl sn_dumpreg
	.ent   sn_dumpreg
sn_dumpreg:
	.frame $30,0,$26,0
	.prologue 0

	# sauvegarde tous les registres
	# r16 et r26 ont dj t sauvs, recopie les valeurs empiles
	# corrige r30 pour tenir compte des 256+16 octets empils
	lda $30, -256($30)
	stq  $0,   0($30)
	stq  $1,   8($30)
	stq  $2,  16($30)
	stq  $3,  24($30)
	stq  $4,  32($30)
	stq  $5,  40($30)
	stq  $6,  48($30)
	stq  $7,  56($30)
	stq  $8,  64($30)
	stq  $9,  72($30)
	stq  $10, 80($30)
	stq  $11, 88($30)
	stq  $12, 96($30)
	stq  $13,104($30)
	stq  $14,112($30)
	stq  $15,120($30)
	ldq  $0, 256($30); stq  $0,128($30)
	stq  $17,136($30)
	stq  $18,144($30)
	stq  $19,152($30)
	stq  $20,160($30)
	stq  $21,168($30)
	stq  $22,176($30)
	stq  $23,184($30)
	stq  $24,192($30)
	stq  $25,200($30)
	ldq  $0, 264($30); stq  $0,208($30)
	stq  $27,216($30)
	stq  $28,224($30)
	stq  $29,232($30)
	lda  $0, 272($30); stq $0,240($30)
	stq  $31,248($30)

	# affiche rx=<valeur hexa>
	# on sauve l adresse de retour dans r9 cens tre prserv par printf
	br     $27, 1f
1:
	ldgp   $gp, 0($27)
	bis    $16, $16, $17
	s8addq $16, $30, $18
	ldq    $18, 0($18)
	lda    $16, sn_dumpreg_fmt
	bis    $26, $26, $9
	jsr    $26, printf
	bis    $9,  $9,  $26

	# rcupre les registres sauf r16, r26, r30 et r31
	ldq  $0,   0($30)
	ldq  $1,   8($30)
	ldq  $2,  16($30)
	ldq  $3,  24($30)
	ldq  $4,  32($30)
	ldq  $5,  40($30)
	ldq  $6,  48($30)
	ldq  $7,  56($30)
	ldq  $8,  64($30)
	ldq  $9,  72($30)
	ldq  $10, 80($30)
	ldq  $11, 88($30)
	ldq  $12, 96($30)
	ldq  $13,104($30)
	ldq  $14,112($30)
	ldq  $15,120($30)
	ldq  $17,136($30)
	ldq  $18,144($30)
	ldq  $19,152($30)
	ldq  $20,160($30)
	ldq  $21,168($30)
	ldq  $22,176($30)
	ldq  $23,184($30)
	ldq  $24,192($30)
	ldq  $25,200($30)
	ldq  $27,216($30)
	ldq  $28,224($30)
	ldq  $29,232($30)
	lda  $30, 256($30)
	
	ret  $31, ($26), 1
	
sn_dumpreg_fmt:
	.ascii "r%ld = %016lX\12\0"

	.end sn_dumpreg

                     # +------------------------------+
                     # |  Affiche le naturel (rx,ry)  |
                     # +------------------------------+
	
#define DUMPNUM(x,y) \
	lda  $30,-32($30) ;\
	stq  $16,  0($30) ;\
	stq  $17,  8($30) ;\
	stq  $26, 16($30) ;\
	bis  $##x, $##x, $16  ;\
	bis  $##y, $##y, $17  ;\
	bsr  $26,  sn_dumpnum ;\
	ldq  $16,  0($30) ;\
	ldq  $17,  8($30) ;\
	ldq  $26, 16($30) ;\
	lda  $30, 32($30)

	.align 5
	.globl sn_dumpnum
	.ent   sn_dumpnum
sn_dumpnum:
	.frame $30,0,$26,0
	.prologue 0

	# sauvegarde tous les registres sauf r16, r17, r30 et r31
	lda $30, -224($30)
	stq  $0,   0($30)
	stq  $1,   8($30)
	stq  $2,  16($30)
	stq  $3,  24($30)
	stq  $4,  32($30)
	stq  $5,  40($30)
	stq  $6,  48($30)
	stq  $7,  56($30)
	stq  $8,  64($30)
	stq  $9,  72($30)
	stq  $10, 80($30)
	stq  $11, 88($30)
	stq  $12, 96($30)
	stq  $13,104($30)
	stq  $14,112($30)
	stq  $15,120($30)
	stq  $18,128($30)
	stq  $19,136($30)
	stq  $20,144($30)
	stq  $21,152($30)
	stq  $22,160($30)
	stq  $23,168($30)
	stq  $24,176($30)
	stq  $25,184($30)
	stq  $26,192($30)
	stq  $27,200($30)
	stq  $28,208($30)
	stq  $29,216($30)

	br   $27, 1f
1:
	ldgp $gp, 0($27)
	jsr  sn_dump
	
	# rcupre les registres empils
	ldq  $0,   0($30)
	ldq  $1,   8($30)
	ldq  $2,  16($30)
	ldq  $3,  24($30)
	ldq  $4,  32($30)
	ldq  $5,  40($30)
	ldq  $6,  48($30)
	ldq  $7,  56($30)
	ldq  $8,  64($30)
	ldq  $9,  72($30)
	ldq  $10, 80($30)
	ldq  $11, 88($30)
	ldq  $12, 96($30)
	ldq  $13,104($30)
	ldq  $14,112($30)
	ldq  $15,120($30)
	ldq  $18,128($30)
	ldq  $19,136($30)
	ldq  $20,144($30)
	ldq  $21,152($30)
	ldq  $22,160($30)
	ldq  $23,168($30)
	ldq  $24,176($30)
	ldq  $25,184($30)
	ldq  $26,192($30)
	ldq  $27,200($30)
	ldq  $28,208($30)
	ldq  $29,216($30)
	lda  $30,224($30)
	
	ret  $31, ($26), 1
	.end sn_dumpnum

