/****************************************************************************************/
/*											*/
/* This program is free software; you can redistribute it and/or modify it under the	*/
/* terms of the GNU General Public License as published by the Free Software		*/
/* Foundation; either version 2 of the License, or (at your option) any later version.	*/
/*											*/
/* This program is distributed in the hope that it will be useful, but WITHOUT ANY	*/
/* WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A	*/
/* PARTICULAR PURPOSE. See the GNU General Public License for more details.		*/
/*											*/
/* You should have received a copy of the GNU General Public License along with this	*/
/* program; (See "COPYING"). If not, If not, see <http://www.gnu.org/licenses/>.        */
/*											*/
/*--------------------------------------------------------------------------------------*/
/*											*/
/*  Copyright   Joerg Anders, TU Chemnitz, Fakultaet fuer Informatik, GERMANY           */
/*		ja@informatik.tu-chemnitz.de						*/
/*											*/
/*											*/
/****************************************************************************************/

#ifndef TEXT_DIALOG_H

#define TEXT_DIALOG_H
#include "config.h"
#include "resource.h"
#include <gtk/gtk.h>
#include <cairo/cairo.h>


class NedTextDialog {
	public:
		NedTextDialog(GtkWindow *parent, char *text, unsigned int tempo, bool enable_tempo, unsigned int volume, bool enable_volume, gchar *font_family, double font_size, cairo_font_slant_t font_slant, cairo_font_weight_t font_weight);
		void getValues(bool *state, char **text, unsigned int *tempo, bool *enable_tempo, unsigned int *volume, bool *enable_volume, gchar **font_family, double *font_size, cairo_font_slant_t *font_slant, cairo_font_weight_t *font_weight);
	private:
		static void CloseCallBack(GtkDialog *dialog, gint result, gpointer data);
		static void FontCallBack(GtkButton *button, gpointer data);
		static void TempoToggled(GtkToggleButton *button, gpointer data);
		static void VolumeToggled(GtkToggleButton *button, gpointer data);
		GtkWidget *m_text_widget;
		GtkWidget *m_font_button;
		GtkWidget *m_tempo_spin_box;
		GtkWidget *m_volume_spin_box;
		GtkWidget *m_check_tempo;
		GtkWidget *m_check_volume;
		unsigned int m_tempo;
		unsigned int m_volume;
		bool m_enable_tempo, m_enable_volume;
		char *m_text;
		gchar *m_font_family;
		double m_font_size;
		cairo_font_slant_t m_font_slant;
		cairo_font_weight_t m_font_weight;
		bool m_state;
};

#endif /* TEXT_DIALOG_H */
