/*
  filemode: print file permissions, in octal.

  Copyright (c) 2002,2006 Carlo Strozzi

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; version 2 dated June, 1991.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

  $Id: filemode.c,v 1.6 2006/03/10 11:26:13 carlo Exp $

*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>

int main(int argc, char **argv)
{
    int count = 0;
    struct stat statbuf;

    if (argc == 1) {
        fprintf(stderr, "Usage: %s file[s]\n", argv[0]);
        exit(1);
    } else {
        while (++count < argc) {
            if (stat(argv[count], &statbuf) < 0) {
                fprintf(stderr, "Stat failure on %s\n", argv[count]);
                exit(1);
            }
            else {
	        if (argc == 2) printf("%04o\n",
					statbuf.st_mode & 00007777);
	        else printf("%s\t%04o\n", argv[count],
					statbuf.st_mode & 00007777);
           }
        }
    }
    exit(0);
}

/* EOF */
