/*
 *  Nikwi Deluxe
 *  Copyright (C) 2006  Kostas Michalopoulos
 *  
 *  A game by Kostas "Bad Sector" Michalopoulos
 *  email: badsector@slashstone.com
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
** Nikwi - a game by Kostas Michalopoulos
*/

#ifndef __NIKWI_H_INCLUDED__
#define __NIKWI_H_INCLUDED__

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <SDL/SDL.h>
#ifdef main
#undef main
#endif

#ifdef WIN32
#define WIN32_MEAN_AND_LEAN
#define WIN32_LEAN_AND_MEAN
#define WIN32_MORE_LEAN
#define WIN32_MORE_MEAN
#define MORE_LEAN
#define MORE_MEAN
#include <windows.h>
#endif

#include <badcfg.h>
#include <uscript/uscript.h>
#include <slashtdp/slashtdp.h>
#include <slashfx.h>

#ifndef __linux__
typedef unsigned int	uint;
#endif
typedef char		*String;

#include "utils.h"
#include "nikio.h"
#include "gfx.h"
#include "sound.h"
#include "sprites.h"
#include "tiles.h"
#include "objects.h"
#include "motion.h"
#include "world.h"
#include "screens.h"
#include "editor.h"
#include "game.h"
#include "menu.h"
#include "imageScreen.h"
#include "ending.h"
#include "transitions.h"

extern bool	running;
extern bool	debugMode;

void resetTimer();

#endif

