/*
 *  Nikwi Deluxe
 *  Copyright (C) 2006  Kostas Michalopoulos
 *  
 *  A game by Kostas "Bad Sector" Michalopoulos
 *  email: badsector@slashstone.com
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
** Nikwi Engine - Ending screen
*/

#include "nikwi.h"

EndingScreen	*ending = NULL;

EndingScreen::EndingScreen()
{
}

EndingScreen::~EndingScreen()
{
}

void EndingScreen::loadImages()
{
	story1 = loadImage("data/objects/story1.ut");
	story2 = loadImage("data/objects/story2.ut");
	story3 = loadImage("data/objects/story3.ut");
	story4 = loadImage("data/objects/story4.ut");
}

void EndingScreen::enter()
{
	Transition	*trans = new MosaicTransition();
	trans->begin();
	game->draw();
	trans->play();
	trans->begin();
	game->draw();
	trans->play();
	delete trans;
	trans = new LinesTransition();
	trans->begin();
	draw();
	trans->play();
	delete trans;
	tick = 0;
	loadImages();
}

void EndingScreen::leave()
{
	SDL_FreeSurface(story4);
	SDL_FreeSurface(story3);
	SDL_FreeSurface(story2);
	SDL_FreeSurface(story1);
}

void EndingScreen::timer()
{
	tick++;
	if (tick == 100 || tick == 300 || tick == 450 || tick == 750 ||
		tick == 1000)
	{
		Transition	*trans;
		if (tick == 100)
			trans = new MosaicTransition();
		else
			trans = new LinesTransition();
		trans->begin();
		draw();
		trans->play();
		delete trans;
	}
	if (tick == 1200)
	{
		imageScreen->nextImageFile = "data/objects/credits.ut";
		imageScreen->showImage(menuScreen, "data/objects/gover.ut",
			320);
	}
}

void EndingScreen::draw()
{
	SDL_Rect	r;
	
	if (SDL_MUSTLOCK(screen))
		SDL_LockSurface(screen);
	memset(screen->pixels, 0, screen->pitch*screen->h);
	if (SDL_MUSTLOCK(screen))
		SDL_UnlockSurface(screen);
	
	if (tick >= 100 && tick < 750)
	{
		r.x = 64;
		r.y = 16;	//160//
		if (SDL_BlitSurface(story1, NULL, screen, &r) != 0)
		{
			loadImages();
			SDL_Delay(100);
			return;
		}
	}
	if (tick >= 300 && tick < 750)
	{
		r.x = 64;
		r.y = 16+160;
		if (SDL_BlitSurface(story2, NULL, screen, &r) != 0)
		{
			loadImages();
			SDL_Delay(100);
			return;
		}
	}
	if (tick >= 450 && tick < 750)
	{
		r.x = 64;
		r.y = 16+320;
		if (SDL_BlitSurface(story3, NULL, screen, &r) != 0)
		{
			loadImages();
			SDL_Delay(100);
			return;
		}
	}
	if (tick >= 750 && tick < 1000)
	{
		r.x = 64;
		r.y = 176;
		if (SDL_BlitSurface(story4, NULL, screen, &r) != 0)
		{
			loadImages();
			SDL_Delay(100);
			return;
		}
	}
}

void EndingScreen::handleEvent(SDL_Event &e)
{
}

