/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Scope;
import gnu.bytecode.SwitchState;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.CheckedTarget;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.ConstructorExp;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Initializer;
import gnu.expr.Keyword;
import gnu.expr.Literal;
import gnu.expr.ModuleExp;
import gnu.expr.ProcInitializer;
import gnu.expr.QuoteExp;
import gnu.expr.ScopeExp;
import gnu.expr.Special;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.lists.LList;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class LambdaExp
extends ScopeExp {
    public String name;
    public Expression body;
    public int min_args;
    public int max_args;
    Vector applyMethods;
    Variable argsArray;
    private Declaration firstArgsArrayArg;
    public Keyword[] keywords;
    public Expression[] defaultArgs;
    public Stack[] parameterCopies;
    static int counter;
    int id = ++counter;
    Declaration capturedVars;
    Variable heapFrame;
    public LambdaExp firstChild;
    public LambdaExp nextSibling;
    static final ApplyExp unknownContinuation;
    public ApplyExp returnContinuation;
    public Declaration nameDecl;
    public Field closureEnvField;
    public Field staticLinkField;
    Variable closureEnv;
    static final int INLINE_ONLY = 1;
    static final int CAN_READ = 2;
    static final int CAN_CALL = 4;
    static final int IMPORTS_LEX_VARS = 8;
    static final int NEEDS_STATIC_LINK = 16;
    static final int CANNOT_INLINE = 32;
    static final int CLASS_METHOD = 64;
    static final int METHODS_COMPILED = 128;
    static final int NO_FIELD = 256;
    static final int DEFAULT_CAPTURES_ARG = 512;
    public static final int SEQUENCE_RESULT = 1024;
    protected static final int NEXT_AVAIL_FLAG = 2048;
    public static String fileFunctionName;
    ClassType type = Compilation.typeProcedure;
    int selectorValue;
    Method[] primMethods;
    Variable thisVariable;
    static Method searchForKeywordMethod3;
    static Method searchForKeywordMethod4;
    Initializer initChain;
    Initializer clinitChain;
    private Field instanceField;
    Literal literalsChain;
    Hashtable literalTable;
    Procedure thisValue;
    Object[] properties;
    protected Type returnType;
    private Attribute attributes;

    public void forceGeneration() {
        this.returnContinuation = unknownContinuation;
    }

    public final boolean getInlineOnly() {
        return (this.flags & 1) != 0;
    }

    public final void setInlineOnly(boolean inlineOnly) {
        this.setFlag(inlineOnly, 1);
    }

    public final boolean getNeedsClosureEnv() {
        return (this.flags & 0x18) != 0;
    }

    public final boolean getNeedsStaticLink() {
        return (this.flags & 0x10) != 0;
    }

    public final void setNeedsStaticLink(boolean needsStaticLink) {
        this.flags = needsStaticLink ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public final boolean getImportsLexVars() {
        return (this.flags & 8) != 0;
    }

    public final void setImportsLexVars(boolean importsLexVars) {
        this.flags = importsLexVars ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public final void setImportsLexVars() {
        int old = this.flags;
        this.flags |= 8;
        if ((old & 8) == 0 && this.nameDecl != null) {
            this.setCallersNeedStaticLink();
        }
    }

    public final void setNeedsStaticLink() {
        int old = this.flags;
        this.flags |= 0x10;
        if ((old & 0x10) == 0 && this.nameDecl != null) {
            this.setCallersNeedStaticLink();
        }
    }

    void setCallersNeedStaticLink() {
        LambdaExp outer = this.outerLambda();
        ApplyExp app = this.nameDecl.firstCall;
        while (app != null) {
            for (LambdaExp caller = app.context; caller != outer; caller = caller.outerLambda()) {
                caller.setNeedsStaticLink();
            }
            app = app.nextCall;
        }
    }

    public final boolean getCanRead() {
        return (this.flags & 2) != 0;
    }

    public final void setCanRead(boolean read2) {
        this.flags = read2 ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public final boolean getCanCall() {
        return (this.flags & 4) != 0;
    }

    public final void setCanCall(boolean called) {
        this.flags = called ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public final boolean isClassMethod() {
        return (this.flags & 0x40) != 0;
    }

    public final void setClassMethod(boolean isMethod) {
        this.flags = isMethod ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
    }

    public final boolean isModuleBody() {
        return this instanceof ModuleExp;
    }

    public final boolean isClassGenerated() {
        return !this.getInlineOnly() && (this.isModuleBody() || this instanceof ClassExp);
    }

    public final boolean isHandlingTailCalls() {
        return this.isModuleBody() && !((ModuleExp)this).isStatic() || Compilation.usingTailCalls && !this.isModuleBody() && !this.isClassMethod();
    }

    public final boolean variable_args() {
        return this.max_args < 0;
    }

    public ClassType getCompiledClassType(Compilation comp) {
        if (this.type == Compilation.typeProcedure) {
            throw new Error("internal error: getCompiledClassType");
        }
        return this.type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public Type[] getArgTypes() {
        Type[] res = new Type[this.max_args];
        int n = 0;
        for (Declaration d = this.firstDecl(); d != null; d = d.nextDecl()) {
            res[n++] = d.getType();
        }
        return res;
    }

    public int incomingArgs() {
        return this.min_args == this.max_args && this.max_args <= 4 && this.max_args > 0 ? this.max_args : 1;
    }

    int getSelectorValue(Compilation comp) {
        if (this.selectorValue == 0) {
            this.selectorValue = ++comp.maxSelectorValue;
        }
        return this.selectorValue;
    }

    public final Method getMethod(int argCount) {
        if (this.primMethods == null || this.max_args >= 0 && argCount > this.max_args) {
            return null;
        }
        int index = argCount - this.min_args;
        if (index < 0) {
            return null;
        }
        int length = this.primMethods.length;
        return this.primMethods[index < length ? index : length - 1];
    }

    public Method getMainMethod() {
        Method[] methods = this.primMethods;
        return methods == null ? null : methods[methods.length - 1];
    }

    public final Type restArgType() {
        if (this.min_args == this.max_args) {
            return null;
        }
        if (this.primMethods == null) {
            throw new Error("internal error - restArgType");
        }
        Method[] methods = this.primMethods;
        if (this.max_args >= 0 && methods.length > this.max_args - this.min_args) {
            return null;
        }
        Type[] types = methods[methods.length - 1].getParameterTypes();
        return types[types.length - 1];
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public LambdaExp outerLambda() {
        return this.outer == null ? null : this.outer.currentLambda();
    }

    public LambdaExp outerLambdaNotInline() {
        ScopeExp exp = this;
        while ((exp = exp.outer) != null) {
            ScopeExp result;
            if (!(exp instanceof LambdaExp) || ((LambdaExp)(result = exp)).getInlineOnly()) continue;
            return result;
        }
        return null;
    }

    public ClassExp outerClass() {
        ScopeExp exp = this;
        while (exp != null) {
            if (exp instanceof ClassExp) {
                return (ClassExp)exp;
            }
            exp = exp.outer;
        }
        return null;
    }

    public LambdaExp getCaller() {
        return this.returnContinuation.context;
    }

    public Variable declareThis(ClassType clas) {
        if (this.thisVariable == null) {
            this.thisVariable = new Variable("this");
            this.scope.addVariableAfter(null, this.thisVariable);
            this.thisVariable.setParameter(true);
            this.thisVariable.setArtificial(true);
        }
        if (this.thisVariable.getType() == null) {
            this.thisVariable.setType(clas);
        }
        return this.thisVariable;
    }

    public Variable declareClosureEnv() {
        if (this.closureEnv == null && this.getNeedsClosureEnv()) {
            Variable parentFrame;
            LambdaExp parent = this.outerLambda();
            if (parent instanceof ClassExp) {
                parent = parent.outerLambda();
            }
            Variable variable = parentFrame = parent.heapFrame != null ? parent.heapFrame : parent.closureEnv;
            if (this.isClassMethod()) {
                this.declareThis(this.type);
            } else if (parent.heapFrame == null && !parent.getNeedsStaticLink() && !(parent instanceof ModuleExp)) {
                this.closureEnv = null;
            } else if (!this.isClassGenerated() && !this.getInlineOnly()) {
                Method primMethod = this.getMainMethod();
                if (!primMethod.getStaticFlag()) {
                    this.declareThis(primMethod.getDeclaringClass());
                } else {
                    Type envType = primMethod.getParameterTypes()[0];
                    this.closureEnv = new Variable("closureEnv", envType);
                    this.scope.addVariableAfter(null, this.closureEnv);
                    this.closureEnv.setArtificial(true);
                    this.closureEnv.setParameter(true);
                }
            } else {
                LambdaExp caller;
                LambdaExp lambdaExp = caller = this.getInlineOnly() ? this.getCaller() : null;
                if (parent == caller) {
                    this.closureEnv = parentFrame;
                } else if (caller != null && parent == caller.outerLambdaNotInline()) {
                    this.closureEnv = caller.closureEnv;
                } else {
                    this.closureEnv = new Variable("closureEnv", parentFrame.getType());
                    this.scope.addVariable(this.closureEnv);
                    this.closureEnv.setArtificial(true);
                }
            }
        }
        return this.closureEnv;
    }

    public LambdaExp() {
    }

    public LambdaExp(int args) {
        this.min_args = args;
        this.max_args = args;
    }

    public LambdaExp(Expression body) {
        this.body = body;
    }

    public void loadHeapFrame(Compilation comp) {
        CodeAttr code = comp.getCode();
        LambdaExp curLambda = comp.curLambda;
        while (curLambda != this && curLambda.getInlineOnly()) {
            curLambda = curLambda.returnContinuation.context;
        }
        if (this == curLambda) {
            if (this.heapFrame == null) {
                code.emitPushThis();
            } else {
                code.emitLoad(this.heapFrame);
            }
        } else {
            if (curLambda.closureEnv == null) {
                code.emitPushThis();
            } else {
                code.emitLoad(curLambda.closureEnv);
            }
            for (LambdaExp parent = curLambda.outerLambda(); parent != this; parent = parent.outerLambda()) {
                if (parent.staticLinkField == null) continue;
                code.emitGetField(parent.staticLinkField);
            }
        }
    }

    Declaration getArg(int i) {
        Declaration var = this.firstDecl();
        while (true) {
            if (var == null) {
                throw new Error("internal error - getArg");
            }
            if (i == 0) {
                return var;
            }
            --i;
            var = var.nextDecl();
        }
    }

    public void compileEnd(Compilation comp) {
        CodeAttr code = comp.getCode();
        if (!this.getInlineOnly()) {
            if (comp.method.reachableHere() && (code.SP > 0 || comp.method.getReturnType().isVoid()) && (!Compilation.usingTailCalls || this.isModuleBody() || this.isClassMethod() || this.isHandlingTailCalls())) {
                if (this.getLine() > 0) {
                    code.putLineNumber(this.getFile(), this.getLine());
                }
                code.emitReturn();
            }
            code.popScope();
        }
        if (!Compilation.fewerClasses) {
            code.popScope();
        }
        if (this.applyMethods != null && this.applyMethods.size() > 0) {
            Method save_method = comp.method;
            ClassType save_class = comp.curClass;
            comp.curClass = this.getHeapFrameType();
            comp.generateApplyMethods(this);
            comp.method = save_method;
            comp.curClass = save_class;
        }
        if (this.heapFrame != null) {
            comp.generateConstructor((ClassType)this.heapFrame.getType(), this);
        }
    }

    Field allocFieldFor(Compilation comp) {
        if (this.nameDecl != null && this.nameDecl.field != null) {
            return this.nameDecl.field;
        }
        String name = this.getName();
        String fname = name == null ? "lambda" : Compilation.mangleName(name);
        int fflags = 16;
        if (this.nameDecl != null && this.nameDecl.context instanceof ModuleExp) {
            if (this.nameDecl.getFlag(2048)) {
                fflags |= 8;
                if (!((ModuleExp)this.nameDecl.context).isStatic()) {
                    fflags &= 0xFFFFFFEF;
                }
            }
            if (!this.nameDecl.isPrivate()) {
                fflags |= 1;
            }
        } else {
            fname = fname + "$Fn" + ++comp.localFieldIndex;
            if (!this.getNeedsClosureEnv()) {
                fflags = (fflags | 8) & 0xFFFFFFEF;
            }
        }
        ClassType frameType = this.getHeapLambda().getHeapFrameType();
        ClassType rtype = Compilation.getMethodProcType(frameType);
        Field field = frameType.addField(fname, rtype, fflags);
        if (this.nameDecl != null) {
            this.nameDecl.field = field;
        }
        return field;
    }

    final void addApplyMethod(LambdaExp lexp) {
        if (this.applyMethods == null) {
            this.applyMethods = new Vector();
            if (this.heapFrame != null) {
                ((ClassType)this.heapFrame.getType()).setSuper(Compilation.typeModuleBody);
            } else {
                this.type.setSuper(Compilation.typeModuleBody);
            }
        }
        this.applyMethods.addElement(lexp);
    }

    public Field compileSetField(Compilation comp) {
        if (comp.usingCPStyle()) {
            this.compile(comp, Type.pointer_type);
        } else {
            this.compileAsMethod(comp);
            this.getHeapLambda().addApplyMethod(this);
        }
        return new ProcInitializer((LambdaExp)this, (Compilation)comp).field;
    }

    @Override
    public void compile(Compilation comp, Target target) {
        ClassType rtype;
        if (target instanceof IgnoreTarget && this.getInlineOnly()) {
            return;
        }
        CodeAttr code = comp.getCode();
        if (comp.usingCPStyle()) {
            ClassType ctype;
            Label func_end = new Label(code);
            LambdaExp saveLambda = comp.curLambda;
            comp.curLambda = this;
            this.type = saveLambda.type;
            this.closureEnv = saveLambda.closureEnv;
            SwitchState fswitch = comp.fswitch;
            int pc = comp.fswitch.getMaxValue() + 1;
            code.emitGoto(func_end);
            Type[] stackTypes = code.saveStackTypeState(true);
            fswitch.addCase(pc, code);
            this.allocParameters(comp);
            this.enterFunction(comp);
            this.compileBody(comp);
            this.compileEnd(comp);
            comp.curLambda = saveLambda;
            func_end.define(code);
            code.restoreStackTypeState(stackTypes);
            rtype = ctype = comp.curClass;
        } else {
            LambdaExp outer = this.outerLambda();
            rtype = Compilation.typeModuleMethod;
            if ((this.flags & 0x100) != 0) {
                this.compileAsMethod(comp);
                ProcInitializer.emitLoadModuleMethod(this, comp);
            } else {
                Field field = this.compileSetField(comp);
                if (field.getStaticFlag()) {
                    code.emitGetStatic(field);
                } else {
                    LambdaExp parent = comp.curLambda;
                    Variable frame = parent.heapFrame != null ? parent.heapFrame : parent.closureEnv;
                    code.emitLoad(frame);
                    code.emitGetField(field);
                }
            }
        }
        target.compileFromStack(comp, rtype);
    }

    public ClassType getHeapFrameType() {
        if (this instanceof ModuleExp || this instanceof ClassExp) {
            return (ClassType)this.getType();
        }
        return (ClassType)this.heapFrame.getType();
    }

    public LambdaExp getHeapLambda() {
        ScopeExp exp = this.outer;
        if (this.getNeedsClosureEnv()) {
            while (true) {
                if (exp == null) {
                    return null;
                }
                if (exp instanceof ModuleExp || exp instanceof ClassExp && ((ClassExp)exp).needsConstructor || exp instanceof LambdaExp && ((LambdaExp)exp).heapFrame != null) {
                    return (LambdaExp)exp;
                }
                exp = exp.outer;
            }
        }
        ClassExp res = this.currentClass();
        if (res.needsConstructor) {
            return res;
        }
        return res.outerLambda();
    }

    void addMethodFor(Compilation comp, ObjectType closureEnvType) {
        LambdaExp heapLambda = this.getHeapLambda();
        ClassType ctype = heapLambda.getHeapFrameType();
        this.addMethodFor(ctype, comp, closureEnvType);
    }

    void addMethodFor(ClassType ctype, Compilation comp, ObjectType closureEnvType) {
        int extraArg;
        int mflags;
        boolean isStatic;
        String name = this.getName();
        LambdaExp outer = this.outerLambda();
        int key_args = this.keywords == null ? 0 : this.keywords.length;
        int opt_args = this.defaultArgs == null ? 0 : this.defaultArgs.length - key_args;
        int numStubs = (this.flags & 0x200) != 0 || Compilation.usingTailCalls ? 0 : opt_args;
        boolean varArgs = this.max_args < 0 || this.min_args + numStubs < this.max_args;
        this.primMethods = new Method[numStubs + 1];
        boolean isInitMethod = false;
        if (this.isClassMethod()) {
            if (outer instanceof ClassExp) {
                ClassExp cl = (ClassExp)outer;
                boolean bl = isStatic = cl.isMakingClassPair() && closureEnvType != null;
                if (this == cl.initMethod) {
                    isInitMethod = true;
                }
            } else {
                isStatic = false;
            }
        } else {
            ModuleExp mexp;
            isStatic = this.thisVariable != null || closureEnvType == ctype ? false : (this.nameDecl == null ? true : (this.nameDecl.getFlag(4096) ? false : (this.nameDecl.getFlag(2048) ? true : (this.nameDecl.context instanceof ModuleExp ? (mexp = (ModuleExp)this.nameDecl.context).getSuperType() == null && mexp.getInterfaces() == null : true))));
        }
        StringBuffer nameBuf = new StringBuffer(60);
        if (!outer.isModuleBody() && !(outer instanceof ClassExp) || name == null) {
            nameBuf.append("lambda");
            nameBuf.append(++comp.method_counter);
        }
        if (name != null) {
            nameBuf.append(Compilation.mangleName(name));
        }
        if (this.getFlag(1024)) {
            nameBuf.append("$C");
        }
        if (Compilation.usingTailCalls && !isInitMethod && !this.isClassMethod()) {
            nameBuf.append("$T");
        }
        int n = mflags = isStatic ? 8 : 0;
        if (this.nameDecl != null) {
            if (this.nameDecl.isSpecifiedPrivate()) {
                mflags |= 2;
            } else if (!this.nameDecl.isPrivate()) {
                mflags |= 1;
            }
        }
        if (isInitMethod) {
            mflags = (mflags & 0xFFFFFFFA) + 2;
        }
        if (ctype.isInterface()) {
            mflags |= 0x400;
        }
        if (!isStatic) {
            if (this.isClassMethod()) {
                this.declareThis(ctype);
            } else {
                this.closureEnv = this.declareThis(ctype);
            }
        }
        PrimType rtype = this.getFlag(1024) || Compilation.usingTailCalls && !this.isClassMethod() ? Type.void_type : this.getReturnType().getImplementationType();
        int n2 = extraArg = closureEnvType != null && closureEnvType != ctype ? 1 : 0;
        if (Compilation.usingTailCalls && !isInitMethod && !this.isClassMethod()) {
            Type[] atypes = new Type[1 + extraArg];
            if (extraArg > 0) {
                atypes[0] = closureEnvType;
            }
            atypes[extraArg] = Compilation.typeCallContext;
            this.primMethods[0] = ctype.addMethod(nameBuf.toString(), atypes, rtype, mflags);
            this.argsArray = new Variable("argsArray", Compilation.objArrayType);
            return;
        }
        for (int i = 0; i <= numStubs; ++i) {
            int plainArgs;
            int numArgs = plainArgs = this.min_args + i;
            if (i == numStubs && varArgs) {
                ++numArgs;
            }
            Type[] atypes = new Type[extraArg + numArgs];
            if (extraArg > 0) {
                atypes[0] = closureEnvType;
            }
            Declaration var = this.firstDecl();
            int itype = 0;
            while (itype < plainArgs) {
                atypes[extraArg + itype++] = var.getType().getImplementationType();
                var = var.nextDecl();
            }
            if (plainArgs < numArgs) {
                nameBuf.append("$V");
                name = nameBuf.toString();
                Type lastType = var.getType();
                String lastTypeName = lastType.getName();
                if (key_args > 0 || numStubs < opt_args || !"gnu.lists.LList".equals(lastTypeName) && !"java.lang.Object[]".equals(lastTypeName)) {
                    lastType = Compilation.objArrayType;
                    this.argsArray = new Variable("argsArray", Compilation.objArrayType);
                }
                this.firstArgsArrayArg = var;
                atypes[atypes.length - 1] = lastType;
            }
            boolean classSpecified = outer instanceof ClassExp || outer instanceof ModuleExp && ((ModuleExp)outer).getFlag(16384);
            name = nameBuf.toString();
            int renameCount = 0;
            int len = nameBuf.length();
            block2: while (true) {
                for (ClassType t = ctype; t != null; t = t.getSuperclass()) {
                    if (t.getDeclaredMethod(name, atypes) != null) {
                        nameBuf.setLength(len);
                        nameBuf.append('$');
                        nameBuf.append(++renameCount);
                        name = nameBuf.toString();
                        continue;
                    }
                    if (classSpecified) break block2;
                }
                break;
            }
            this.primMethods[i] = ctype.addMethod(name, atypes, rtype, mflags);
        }
        this.addAttributes(this.getMainMethod());
    }

    public void allocChildClasses(Compilation comp) {
        if (this instanceof ModuleExp) {
            ((ModuleExp)this).allocFields(comp);
        } else {
            Method main2 = this.getMainMethod();
            Declaration decl = this.firstDecl();
            if (this.isHandlingTailCalls()) {
                this.firstArgsArrayArg = decl;
                if (!Compilation.usingTailCalls) {
                    this.scope.addVariable(null, Compilation.typeCallContext, "$ctx");
                }
            }
            while (true) {
                if (decl == this.firstArgsArrayArg && this.argsArray != null) {
                    this.scope.addVariable(this.argsArray);
                    this.argsArray.setParameter(true);
                    this.argsArray.setArtificial(true);
                }
                if (decl == null) break;
                Variable var = decl.var;
                if (decl.isSimple() && !decl.isIndirectBinding()) {
                    var = decl.allocateVariable(null);
                } else {
                    String vname = Compilation.mangleName(decl.getName()).intern();
                    var = decl.var = this.scope.addVariable(null, decl.getType(), vname);
                    var.setArtificial(true);
                    var.setParameter(true);
                }
                decl = decl.nextDecl();
            }
        }
        this.declareClosureEnv();
        if (comp.usingCPStyle() && comp.curClass == comp.mainClass) {
            return;
        }
        this.allocFrame(comp);
        LambdaExp child = this.firstChild;
        while (child != null) {
            if (child.isClassGenerated()) {
                if (child.min_args != child.max_args || child.min_args > 4 || child.isHandlingTailCalls()) {
                    child.argsArray = new Variable("argsArray", Compilation.objArrayType);
                    child.firstArgsArrayArg = child.firstDecl();
                }
            } else if (!child.getInlineOnly()) {
                ClassType closureEnvType;
                if (!child.getNeedsClosureEnv()) {
                    closureEnvType = null;
                } else if (this instanceof ClassExp) {
                    closureEnvType = this.getCompiledClassType(comp);
                } else if ("$finit$".equals(this.getName())) {
                    closureEnvType = this.outerLambda().getCompiledClassType(comp);
                } else {
                    LambdaExp owner = this;
                    while (owner.heapFrame == null) {
                        owner = owner.outerLambda();
                    }
                    closureEnvType = (ClassType)owner.heapFrame.getType();
                }
                child.addMethodFor(comp, closureEnvType);
            }
            child = child.nextSibling;
        }
    }

    public void allocFrame(Compilation comp) {
        if (this.heapFrame != null) {
            ClassType frameType;
            if (this instanceof ModuleExp || this instanceof ClassExp) {
                frameType = this.getCompiledClassType(comp);
            } else {
                ClassExp outerClass = this.outerClass();
                if (outerClass != null) {
                    String name = this.getName();
                    if (name == null) {
                        name = "lambda";
                    }
                    name = Compilation.mangleName(name);
                    name = outerClass.getName() + "$" + name;
                    name = comp.generateUniqueName(name);
                    frameType = new ClassType(name);
                    if (outerClass.getFile() != null) {
                        frameType.setSourceFile(outerClass.getFile());
                    }
                } else {
                    frameType = new ClassType(comp.generateClassName("frame"));
                }
                if (Compilation.usingTailCalls) {
                    frameType.setSuper(Type.pointer_type);
                } else {
                    frameType.setSuper(Compilation.typeModuleBody);
                }
                comp.addClass(frameType);
            }
            this.heapFrame.setType(frameType);
        }
    }

    void allocParameters(Compilation comp) {
        CodeAttr code = comp.getCode();
        int i = 0;
        int j = 0;
        if (this.isHandlingTailCalls() && !this.isModuleBody()) {
            if (!comp.usingCPStyle()) {
                comp.callStackContext = new Variable("$ctx", Compilation.typeCallContext);
                this.scope.addVariableAfter(this.thisVariable, comp.callStackContext);
                comp.callStackContext.setParameter(true);
                comp.callStackContext.setArtificial(true);
            }
        }
        code.locals.enterScope(this.scope);
        if (this.argsArray != null && this.isHandlingTailCalls()) {
            code.emitLoad(comp.callStackContext);
            code.emitInvoke(Compilation.typeCallContext.getDeclaredMethod("getArgs", 0));
            code.emitStore(this.argsArray);
        }
        for (Declaration decl = this.firstDecl(); decl != null; decl = decl.nextDecl()) {
            Variable var = decl.var;
            if (this.argsArray != null && this.min_args == this.max_args && this.primMethods == null && !this.isHandlingTailCalls()) {
                code.emitLoad(this.argsArray);
                code.emitPushInt(j);
                code.emitArrayLoad(Type.pointer_type);
                decl.getType().emitCoerceFromObject(code);
                code.emitStore(decl.getVariable());
            }
            ++j;
            ++i;
        }
        if (this.heapFrame != null) {
            this.heapFrame.allocateLocal(code);
        }
    }

    void addInitializer(Initializer elem) {
        elem.next = this.initChain;
        this.initChain = elem;
    }

    void addClassInitializer(Initializer elem) {
        elem.next = this.clinitChain;
        this.clinitChain = elem;
    }

    Field getInstanceField() {
        if (this.instanceField == null) {
            this.instanceField = this.type.addField("$instance", this.type, 25);
        }
        return this.instanceField;
    }

    void generateClassInit(Compilation comp) {
        if (this.instanceField == null && this.clinitChain == null && this.literalsChain == null) {
            return;
        }
        Method method = this.type.addMethod("<clinit>", Type.typeArray0, Type.void_type, 9);
        method.init_param_slots();
        CodeAttr code = method.getCode();
        Label lab0 = new Label(code);
        Label lab1 = new Label(code);
        Label lab2 = new Label(code);
        code.emitGoto(lab2);
        lab0.define(code);
        if (this.clinitChain != null) {
            Label lastClinit = new Label(code);
            code.emitGoto(lastClinit);
            Label previous = null;
            while (this.clinitChain != null) {
                Label current = new Label(code);
                current.define(code);
                Initializer chain = this.clinitChain;
                this.clinitChain = null;
                comp.dumpInitializers(chain, method);
                if (previous != null) {
                    code.emitGoto(previous);
                } else {
                    method.getCode().emitReturn();
                }
                if (this.clinitChain == null) {
                    lastClinit.define(code);
                    code.emitGoto(current);
                    continue;
                }
                previous = current;
            }
        } else {
            method.getCode().emitReturn();
        }
        lab1.define(code);
        comp.literalsChain = this.literalsChain;
        comp.litTable = null;
        comp.method = method;
        Literal.emit(comp);
        code.emitGoto(lab0);
        lab2.define(code);
        if (this.instanceField != null) {
            comp.generateConstructor(this);
            if (this.type.constructor != null) {
                code.emitNew(this.type);
                code.emitDup(this.type);
                code.emitInvokeSpecial(this.type.constructor);
                code.emitPutStatic(this.instanceField);
            }
        } else if (this instanceof ClassExp) {
            comp.generateConstructor(this);
        }
        code.emitGoto(lab1);
    }

    void enterFunction(Compilation comp) {
        int opt_args;
        CodeAttr code = comp.getCode();
        this.scope.setStartPC(code.getPC());
        if (this.closureEnv != null && !this.closureEnv.isParameter()) {
            if (!comp.usingCPStyle()) {
                if (this.getInlineOnly()) {
                    this.outerLambda().loadHeapFrame(comp);
                } else {
                    code.emitPushThis();
                    Field field = this.closureEnvField;
                    if (field == null) {
                        field = this.outerLambda().closureEnvField;
                    }
                    code.emitGetField(field);
                }
                code.emitStore(this.closureEnv);
            }
        }
        if (this.heapFrame != null) {
            if (!comp.usingCPStyle()) {
                ClassType frameType = (ClassType)this.heapFrame.getType();
                Declaration decl = this.capturedVars;
                while (decl != null) {
                    if (decl.field == null) {
                        Field fld;
                        String dname;
                        String mname = dname = Compilation.mangleName(decl.getName());
                        int i = 0;
                        while ((fld = frameType.getField(mname)) != null) {
                            mname = dname + '_' + ++i;
                        }
                        Type dtype = decl.getType();
                        decl.field = frameType.addField(mname, decl.getType());
                    }
                    decl = decl.nextCapturedVar;
                }
                if (this.closureEnv != null && this.heapFrame != null) {
                    this.staticLinkField = frameType.addField("staticLink", this.closureEnv.getType());
                }
                if (!(this instanceof ModuleExp) && !(this instanceof ClassExp)) {
                    code.emitNew(frameType);
                    code.emitDup(frameType);
                    Method constructor = Compilation.getConstructor(frameType, this);
                    code.emitInvokeSpecial(constructor);
                    if (this.staticLinkField != null && !(this instanceof ConstructorExp)) {
                        code.emitDup(this.heapFrame.getType());
                        code.emitLoad(this.closureEnv);
                        code.emitPutField(this.staticLinkField);
                    }
                    code.emitStore(this.heapFrame);
                }
            }
        }
        Variable argsArray = this.argsArray;
        if (this.min_args == this.max_args) {
            if (!Compilation.fewerClasses && this.primMethods == null && !this.isHandlingTailCalls()) {
                argsArray = null;
            }
        }
        int i = 0;
        int opt_i = 0;
        int key_i = 0;
        int key_args = this.keywords == null ? 0 : this.keywords.length;
        int n = opt_args = this.defaultArgs == null ? 0 : this.defaultArgs.length - key_args;
        if (this instanceof ModuleExp) {
            return;
        }
        int plainArgs = -1;
        int defaultStart = 0;
        Method mainMethod = this.getMainMethod();
        for (Declaration param = this.firstDecl(); param != null; param = param.nextDecl()) {
            if (param == this.firstArgsArrayArg && argsArray != null) {
                if (this.primMethods != null && !Compilation.usingTailCalls) {
                    plainArgs = i;
                    defaultStart = plainArgs - this.min_args;
                } else {
                    plainArgs = 0;
                    defaultStart = 0;
                }
            }
            if (plainArgs >= 0 || !param.isSimple() || param.isIndirectBinding()) {
                Type stackType;
                Type paramType = param.getType();
                Type type = stackType = mainMethod == null || plainArgs >= 0 ? Type.pointer_type : paramType;
                if (!param.isSimple()) {
                    param.loadOwningObject(comp);
                }
                if (plainArgs < 0) {
                    code.emitLoad(param.getVariable());
                } else if (i < this.min_args) {
                    code.emitLoad(argsArray);
                    code.emitPushInt(i);
                    code.emitArrayLoad(Type.pointer_type);
                } else if (i < this.min_args + opt_args) {
                    code.emitPushInt(i - plainArgs);
                    code.emitLoad(argsArray);
                    code.emitArrayLength();
                    code.emitIfIntLt();
                    code.emitLoad(argsArray);
                    code.emitPushInt(i - plainArgs);
                    code.emitArrayLoad(Type.pointer_type);
                    code.emitElse();
                    this.defaultArgs[defaultStart + opt_i++].compile(comp, paramType);
                    code.emitFi();
                } else if (this.max_args < 0 && i == this.min_args + opt_args) {
                    code.emitLoad(argsArray);
                    code.emitPushInt(i - plainArgs);
                    code.emitInvokeStatic(Compilation.makeListMethod);
                    stackType = Compilation.scmListType;
                } else {
                    Type[] argts;
                    code.emitLoad(argsArray);
                    code.emitPushInt(this.min_args + opt_args - plainArgs);
                    comp.compileConstant(this.keywords[key_i++]);
                    Expression defaultArg = this.defaultArgs[defaultStart + opt_i++];
                    if (defaultArg instanceof QuoteExp) {
                        if (searchForKeywordMethod4 == null) {
                            argts = new Type[]{Compilation.objArrayType, Type.int_type, Type.pointer_type, Type.pointer_type};
                            searchForKeywordMethod4 = Compilation.scmKeywordType.addMethod("searchForKeyword", argts, Type.pointer_type, 9);
                        }
                        defaultArg.compile(comp, paramType);
                        code.emitInvokeStatic(searchForKeywordMethod4);
                    } else {
                        if (searchForKeywordMethod3 == null) {
                            argts = new Type[]{Compilation.objArrayType, Type.int_type, Type.pointer_type};
                            searchForKeywordMethod3 = Compilation.scmKeywordType.addMethod("searchForKeyword", argts, Type.pointer_type, 9);
                        }
                        code.emitInvokeStatic(searchForKeywordMethod3);
                        code.emitDup(1);
                        comp.compileConstant(Special.dfault);
                        code.emitIfEq();
                        code.emitPop(1);
                        defaultArg.compile(comp, paramType);
                        code.emitFi();
                    }
                }
                if (paramType != stackType) {
                    CheckedTarget.emitCheckedCoerce(comp, this, i, paramType);
                }
                if (param.isIndirectBinding()) {
                    param.pushIndirectBinding(comp);
                }
                if (param.isSimple()) {
                    code.emitStore(param.getVariable());
                } else {
                    code.emitPutField(param.field);
                }
            }
            ++i;
        }
    }

    void compileChildMethods(Compilation comp) {
        LambdaExp child = this.firstChild;
        while (child != null) {
            if (!(child.getCanRead() || child.getInlineOnly() || child.isHandlingTailCalls())) {
                child.compileAsMethod(comp);
            }
            child = child.nextSibling;
        }
    }

    void compileAsMethod(Compilation comp) {
        if ((this.flags & 0x80) != 0) {
            return;
        }
        this.flags |= 0x80;
        Method save_method = comp.method;
        LambdaExp save_lambda = comp.curLambda;
        Variable saveStackContext = comp.callStackContext;
        comp.curLambda = this;
        if (this.primMethods == null) {
            this.outer = (ClassExp)comp.topLambda;
            this.addMethodFor(comp.topClass, comp, null);
            this.compileAsMethod(comp);
        }
        Method method = this.primMethods[0];
        boolean isStatic = method.getStaticFlag();
        int numStubs = this.primMethods.length - 1;
        Type restArgType = this.restArgType();
        int[] saveDeclFlags = null;
        if (numStubs > 0) {
            saveDeclFlags = new int[this.min_args + numStubs];
            int k = 0;
            Declaration decl = this.firstDecl();
            while (k < this.min_args + numStubs) {
                saveDeclFlags[k++] = decl.flags;
                decl = decl.nextDecl();
            }
        }
        for (int i = 0; i <= numStubs; ++i) {
            comp.method = this.primMethods[i];
            if (i < numStubs) {
                int toCall;
                comp.method.init_param_slots();
                CodeAttr code = comp.getCode();
                for (toCall = i + 1; toCall < numStubs && this.defaultArgs[toCall] instanceof QuoteExp; ++toCall) {
                }
                boolean thisArg = !isStatic;
                boolean varArgs = toCall == numStubs && restArgType != null;
                Variable var = code.getArg(0);
                if (!isStatic) {
                    code.emitPushThis();
                    if (this.getNeedsClosureEnv()) {
                        this.closureEnv = var;
                    }
                    var = code.getArg(1);
                }
                Declaration decl = this.firstDecl();
                int j = 0;
                while (j < this.min_args + i) {
                    decl.flags |= 0x40;
                    decl.var = var;
                    code.emitLoad(var);
                    var = var.nextVar();
                    ++j;
                    decl = decl.nextDecl();
                }
                j = i;
                while (j < toCall) {
                    Target paramTarget = StackTarget.getInstance(decl.getType());
                    this.defaultArgs[j].compile(comp, paramTarget);
                    ++j;
                    decl = decl.nextDecl();
                }
                if (varArgs) {
                    QuoteExp arg;
                    String lastTypeName = restArgType.getName();
                    if ("gnu.lists.LList".equals(lastTypeName)) {
                        arg = new QuoteExp(LList.Empty);
                    } else if ("java.lang.Object[]".equals(lastTypeName)) {
                        arg = new QuoteExp(Values.noArgs);
                    } else {
                        throw new Error("unimplemented #!rest type");
                    }
                    arg.compile(comp, restArgType);
                }
                if (isStatic) {
                    code.emitInvokeStatic(this.primMethods[toCall]);
                } else {
                    code.emitInvokeVirtual(this.primMethods[toCall]);
                }
                code.emitReturn();
                this.closureEnv = null;
                continue;
            }
            if (saveDeclFlags != null) {
                int k = 0;
                Declaration decl = this.firstDecl();
                while (k < this.min_args + numStubs) {
                    decl.flags = saveDeclFlags[k++];
                    decl.var = null;
                    decl = decl.nextDecl();
                }
            }
            if (comp.curClass.isInterface() && comp.method.isAbstract()) continue;
            comp.method.initCode();
            this.allocChildClasses(comp);
            this.allocParameters(comp);
            this.enterFunction(comp);
            this.compileBody(comp);
            this.compileEnd(comp);
        }
        this.compileChildMethods(comp);
        comp.method = save_method;
        comp.curLambda = save_lambda;
        comp.callStackContext = saveStackContext;
    }

    public void compileBody(Compilation comp) {
        Target target;
        if (this.isHandlingTailCalls()) {
            CodeAttr code = comp.getCode();
            Variable ctxVar = comp.callStackContext;
            code.emitLoad(ctxVar);
            code.emitGetField(Compilation.typeCallContext.getDeclaredField("consumer"));
            Scope scope = code.getCurrentScope();
            Variable result = scope.addVariable(code, Compilation.typeConsumer, "$result");
            code.emitStore(result);
            target = new ConsumerTarget(result);
        } else {
            target = Target.pushValue(comp.method.getReturnType());
        }
        this.body.compileWithPosition(comp, target);
    }

    @Override
    protected Expression walk(ExpWalker walker) {
        return walker.walkLambdaExp(this);
    }

    @Override
    protected void walkChildren(ExpWalker walker) {
        this.walkChildrenOnly(walker);
        this.walkProperties(walker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void walkChildrenOnly(ExpWalker walker) {
        LambdaExp save2 = walker.currentLambda;
        walker.currentLambda = this;
        try {
            walker.walkDefaultArgs(this);
            if (walker.exitValue == null && this.body != null) {
                this.body = this.body.walk(walker);
            }
        }
        finally {
            walker.currentLambda = save2;
        }
    }

    protected final void walkProperties(ExpWalker walker) {
        if (this.properties != null) {
            int len = this.properties.length;
            for (int i = 1; i < len; i += 2) {
                Object val = this.properties[i];
                if (!(val instanceof Expression)) continue;
                this.properties[i] = ((Expression)this.properties[i]).walk(walker);
            }
        }
    }

    @Override
    public void print(OutPort out) {
        out.startLogicalBlock("(Lambda/", ")", 2);
        if (this.name != null) {
            out.print(this.name);
            out.print('/');
        }
        out.print(this.id);
        out.print('/');
        out.writeSpaceFill();
        this.printLineColumn(out);
        out.print('(');
        Special prevMode = null;
        int i = 0;
        int opt_i = 0;
        int key_args = this.keywords == null ? 0 : this.keywords.length;
        int opt_args = this.defaultArgs == null ? 0 : this.defaultArgs.length - key_args;
        for (Declaration decl = this.firstDecl(); decl != null; decl = decl.nextDecl()) {
            Special mode = i < this.min_args ? null : (i < this.min_args + opt_args ? Special.optional : (this.max_args < 0 && i == this.min_args + opt_args ? Special.rest : Special.key));
            if (i > 0) {
                out.writeSpaceFill();
            }
            if (mode != prevMode) {
                out.print(mode);
                out.writeSpaceFill();
            }
            Expression defaultArg = null;
            if ((mode == Special.optional || mode == Special.key) && this.defaultArgs != null) {
                defaultArg = this.defaultArgs[opt_i++];
            }
            if (defaultArg != null) {
                out.print('(');
            }
            out.print(decl.getName());
            if (defaultArg != null && defaultArg != QuoteExp.falseExp) {
                out.print(' ');
                defaultArg.print(out);
                out.print(')');
            }
            ++i;
            prevMode = mode;
        }
        out.print(')');
        out.writeSpaceLinear();
        if (this.body == null) {
            out.print("<null body>");
        } else {
            this.body.print(out);
        }
        out.endLogicalBlock(")");
    }

    protected final String getExpClassName() {
        String cname = this.getClass().getName();
        int index = cname.lastIndexOf(46);
        if (index >= 0) {
            cname = cname.substring(index + 1);
        }
        return cname;
    }

    public String toString() {
        String str = this.getExpClassName() + ':' + this.name + '/' + this.id + '/';
        int l = this.getLine();
        if (l <= 0 && this.body != null) {
            l = this.body.getLine();
        }
        if (l > 0) {
            str = str + "l:" + l;
        }
        return str;
    }

    public Object getProperty(Object key, Object defaultValue) {
        if (this.properties != null) {
            int i = this.properties.length;
            while ((i -= 2) >= 0) {
                if (this.properties[i] != key) continue;
                return this.properties[i + 1];
            }
        }
        return defaultValue;
    }

    public synchronized void setProperty(Object key, Object value) {
        this.properties = Procedure.setProperty(this.properties, key, value);
    }

    public final Type getReturnType() {
        if (this.returnType == null) {
            this.returnType = Type.pointer_type;
            this.returnType = this.body.getType();
        }
        return this.returnType;
    }

    public final void setReturnType(Type returnType) {
        this.returnType = returnType;
    }

    public void addBytecodeAttribute(Attribute a) {
        a.setNext(this.attributes);
        this.attributes = a;
    }

    void addAttributes(AttrContainer bytecode) {
        Attribute a = this.attributes;
        while (a != null) {
            Attribute next = a.getNext();
            a.addToFrontOf(bytecode);
            a = next;
        }
    }

    static {
        unknownContinuation = new ApplyExp((Expression)null, null);
        fileFunctionName = "atFileLevel";
    }
}

