/*  VER 052   TAB P   $Id: bounce.c,v 1.8.2.1 2003/05/18 10:57:24 egil Exp $
 *
 *  bounce message, i.e. return to sender
 *
 *  copyright 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: bounce.c,v $
 *  Revision 1.8.2.1  2003/05/18 10:57:24  egil
 *  Version 1.6, with fixes from bug #237
 *
 *  Revision 1.8  1999/03/07 14:58:17  src
 *  Read newsconfig supported. Storage API supported.
 *
 *  Revision 1.7  1998/09/09 07:32:10  src
 *  Version 1.1
 *
 *  Revision 1.6  1998/09/02 06:50:30  src
 *  newsx version 1.0
 *
 *  Revision 1.5  1998/08/24 07:10:53  src
 *  Removed HAVE_SENDMAIL and HAVE_RNEWS
 */

#include "common.h"
#include "proto.h"
#include "options.h"

static void 
do_bounce(FILE *f,char *to,char *a_data,int a_len,time_t a_arrived,
				char *filename,char *msgid,char *reason);

/*
 *  bounce the message
 */
int  
bounce_msg(char *to,char *a_data,int a_len,time_t a_arrived,
			    char *filename, char *msgid, char *reason)
{
    int n;
    int child_pid;
    FILE *f;

    progtitle("bounce message");

    /* send bounce if there is a return address */
    if (!to || !to[0]) return 0;
    log_msg(L_DEBUGMORE,"forking...");
    if (!(f=fork_write(SENDMAIL_PATH,&child_pid,to,NULL))) {
	log_msg(L_ERR,"can't run sendmail: %s",SENDMAIL_PATH);
	return 0;
    }
    log_msg(L_DEBUGMORE,"write...");
    /* generate mail message */
    do_bounce(f,to,a_data,a_len,a_arrived,filename,msgid,reason);
    fclose(f);

    /* wait for child to finish */
    log_msg(L_DEBUGMORE,"wait pid %d...",child_pid);
    n = wait_pid(child_pid);
    log_msg(L_DEBUG,"sendmail status is %d",n);
    return n==0;
}

/*
 *  generate the bounce message
 */
static void 
do_bounce(FILE *f,char *to, char *a_data,int a_len,time_t a_arrived,char *filename,char *msgid,char *reason)
{
    char *sep = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"; /* BUG: */

    /* BUG: check for EOF on f? */
    fprintf(f,"To: %s\n",to);
    fprintf(f,"Subject: News posting failed\n"); /* BUG: */
    fprintf(f,"Auto-Submitted: auto-generated (failure)\n");
    if (attach == 0) {
	fprintf(f,"MIME-Version: 1.0\n");
	fprintf(f,"Content-Type: MULTIPART/MIXED; BOUNDARY=\"%s\"\n",sep);
    }
    fprintf(f,"\n");

    if (attach == 0) {
	fprintf(f,"--%s\n",sep);
	fprintf(f,"Content-Type: TEXT/PLAIN; charset=US-ASCII\n\n");
    }
    fprintf(f,"   ----- The following news message could not be posted -----\n");
    fprintf(f,"Message-ID: %s\n",msgid);
    fprintf(f,"Spool file: %s\n",filename);
    if (a_arrived) {
	fprintf(f,"Entered: %s\n",text_time(a_arrived));
    }
    fprintf(f,"Host: %s %s\n\n",
	       hostname,strcmp(hostport,NNTP_PORT_NAME)==0 ? "" : hostport);
    fprintf(f,"   ----- Reason for failure -----\n");
    fprintf(f,"%s\n\n",reason);

    if (attach != 'n') {
	if (!a_data) {
	    fprintf(f,"   ----- Message text not available -----\n");
	} else {
	    fprintf(f,"   ----- Complete message follows -----\n");
	    if (attach == 0) {
		fprintf(f,"--%s\n",sep);
		fprintf(f,"Content-Type: TEXT/PLAIN; charset=%s\n",
						 /* BUG: */ "US-ASCII");
		fprintf(f,"Content-ID: %s\n",msgid);
		fprintf(f,"Content-Description: Failed posting to %s\n\n",
								    hostname);
	    }
	    /* and copy */
#if 0 /* BUG: article.. */
	    char line[1024];
	    int n;
	
	    while ((n=fread(line, 1, sizeof(line), art)) > 0) {
		/* BUG: no error check */
		fwrite(line, 1, n, f);
	    }
#else
	    fwrite(a_data, 1, a_len, f);
#endif
	}
    }
}            


