#ifndef tagsouppullparser_H_
#define tagsouppullparser_H_

#include <string>
#include <utility>
#include <vector>

namespace newsbeuter
{

class tagsouppullparser
{
public:
	enum event { START_DOCUMENT, END_DOCUMENT, START_TAG, END_TAG, TEXT };
	
	tagsouppullparser();
	virtual ~tagsouppullparser();
	void setInput(std::istream& is);
	int getAttributeCount() const;
	std::string getAttributeName(unsigned int index) const;
	std::string getAttributeValue(unsigned int index) const;
	std::string getAttributeValue(const std::string& name) const;
	event getEventType() const;
	std::string getText() const;
	bool isWhitespace() const;
	event next();
	
private:
	typedef std::pair<std::string,std::string> attribute;
	std::vector<attribute> attributes;
	std::string text;
	std::istream * inputstream;
	event current_event;
	
	int skip_whitespace(std::string& ws);
	void add_attribute(std::string s);
	std::string read_tag();
	event determine_tag_type();
	std::string decode_attribute(const std::string& s);
	std::string decode_entities(const std::string& s);
	std::string decode_entity(std::string s);
	void remove_trailing_whitespace(std::string& s);

	
};

}

#endif /*tagsouppullparser_H_*/
