/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include "Error.h"
#include <mString.h>
#include "clintl.h"
#include "DlgError.h"

#ifdef _WIN32
	void ErrorHandler(const char * Message, wxWindow * wParent, unsigned long error_code, char * Filename, int Line)
#else
	void ErrorHandler(const char * Message, wxWindow * wParent, int error_code, char * Filename, int Line)
#endif
{
	mString openssl_msg;
	mString str_tmp;

	#ifdef _WIN32
		#define PATH_SEP '\\'
	#else
		#define PATH_SEP '/'
	#endif

	Filename = strrchr(Filename, PATH_SEP);
	if(Filename)
	{
		Filename++;
	}
	else
	{
		Filename = "Unknown";
	}
	#undef PATH_SEP



	#ifdef NEWPKI_DEBUG
		#define ERROR_TEMPLATE "%s\n--------------------------------------------------------\nFile:%s\nLine:%d\n"
	#else
		#define ERROR_TEMPLATE "%s\n"
	#endif


	if(!Message)
	{
		// Is is an error code ?
		if(error_code)
		{
			#ifdef _WIN32
				char ttMsg[500];
				FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,NULL,error_code,MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), ttMsg, sizeof(ttMsg), NULL);
				Message = ttMsg;
			#else
				Message = strerror(error_code);
			#endif
		}
		else
		{
			// We load the error from OpenSSL error stack
			ERR_to_mstring(openssl_msg);
			Message = openssl_msg.c_str();
		}
	}

	#ifdef NEWPKI_DEBUG
		str_tmp.sprintf(ERROR_TEMPLATE, Message, Filename, Line);
	#else
		str_tmp.sprintf(ERROR_TEMPLATE, Message);
	#endif

	DlgError Dlg(wParent, str_tmp);

	#undef ERROR_TEMPLATE
}

