/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgLogin.h: interface for the DlgLogin class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGLOGIN_H
#define DLGLOGIN_H

#include <stdio.h>
#include <stdlib.h>

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif
#include "wx/app.h"
#include "wx/dialog.h"




#ifdef _WIN32
	#include <windows.h>
	#undef FindWindow
#endif

#include <openssl/x509.h>
#include <PKI_PKCS12.h>

#include "Error.h"
#include <PkiClient.h>

#ifdef _WIN32
	#include <windows.h>
	#include <wincrypt.h>
#endif



typedef struct st_LOGIN_INFO
{
	char CaName[50];
	char Username[50];
	char Password[50];
	char Server[50];
	unsigned int Port;
	PKI_CERT p12_cert;
	PCCERT_CONTEXT pCert;
}LOGIN_INFO;

class DlgLogin: public wxDialog
{
public:
	bool GetLoginInfo(LOGIN_INFO * LoginInfo);
	DlgLogin(wxWindow * wParent);
	virtual ~DlgLogin();

	void OnCancel(wxCommandEvent& event);
	void OnOk(wxCommandEvent& event);
	void OnLoginPassord(wxCommandEvent& event);
	void OnPKCS12(wxCommandEvent& event);
	void OnMSCERT(wxCommandEvent& event);
	void OnBrowsePKC12(wxCommandEvent& event);
	
private:
	#define NEWPKI_PATH		"SOFTWARE\\Newpki"
	#define ENV_PKI_FILE "/.newpki/client_pki"

	#define ENV_PKI_SERVER		"server"
	#define ENV_PKI_PORT		"port"
	#define ENV_PKI_USER		"username"
	#define ENV_PKI_CA			"caname"
	#define ENV_PKI_TYPE		"type"
	#define ENV_PKI_P12FILE		"p12file"
	#define ENV_PKI_CERTNAME	"certname"
	
	void LoadConf();
	void WriteConf();
	
	static bool SetLoginValue(char * OptionName, const char * Value);
	static char * GetLoginValue(char * OptionName);

	LOGIN_INFO LogInfos;
	bool IsOk;

	#ifdef _WIN32
		HCERTSTORE hMy;
		PCCERT_CONTEXT hCert;
	#endif
	PKI_PKCS12 p12;

	DECLARE_EVENT_TABLE()
};

#endif
