/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: users.h,v 1.24 2009-08-01 09:23:55 anton Exp $ */

// user modes definition
enum user_mode { USER_HUMAN, USER_DATASOURCE, USER_STORAGE };

//////////////////////////////////////////////////////////////////////////
class User: public Object {
	public:
		char *real_name;
		char *name;
		char *email;
		char *password;
		char *sms;
		u_char permissions;
		u_char hidden;
#ifdef HAVE_PAM
		u_char pam_auth;
#endif
		User(char *name, u_char hidden=0);
		~User();
		user_mode mode;

		void setName(char *s);
		void setRealName(char *s);
		void setEmail(char *s);
		void setSms(char *s);
		void setPermissions(char *s);
		u_char getPermissions();
		};

//////////////////////////////////////////////////////////////////////////
class UsersList: public List {
	public:
		u_char changed_pw;
		u_char changed_user;
		UsersList();
		~UsersList() {};
		User *getUser(char *name);
		void listUsers(struct cli_def *cli);
		void listUsersCfg(struct cli_def *cli, u_char flags=0);
		void listUsersHtml(FILE *f);
		void listPasswordsHtml(FILE *f);
		};

//////////////////////////////////////////////////////////////////////////
int cUser(Connection *conn, char *param[], u_char no_flag);
//////////////////////////////////////////////////////////////////////////
