/*************************************************************************
***	Authentication, authorization, accounting + firewalling package
***	Copyright 1998-2002 Anton Vinokurov <anton@netams.com>
***	Copyright 2002-2008 NeTAMS Development Team
***	This code is GPL v3
***	For latest version and more info, visit this project web page
***	located at http://www.netams.com
***
*************************************************************************/
/* $Id: ascii2netflow.c,v 1.6 2009-08-01 09:23:55 anton Exp $ */

#include "config.h"
extern "C" {
	#include "../lib/lib.h"
}

#define NETFLOW_CLASS
#include "netflow.h"


#undef CHECK_POLL
#define CHECK_POLL(status) {                                                            \
        if ((status = poll(&pfd, 1, POLL_TIMEOUT)) < 0 && errno != EINTR) {     \
                printf("poll: %s\n", strerror(errno));      \
                continue;                                                       \
        }                                                                       \
}

extern u_char debug, quiet;
extern void Debug(const char *msg,...);

char *destination=NULL;
const char *dst_host=NULL;
unsigned short dst_port=20001;
u_char hupset=0;

class NetFlow *Flow;

struct packet {
	struct ip ip;
	struct tcphdr tcp;
};
	
#define MY_MALLOC(x) malloc(x)
#define MY_FREE(x) free(x)

void termination(){
	if (debug && !quiet) {
		Flow->Status();
	}
	delete Flow;
	
	signal(SIGINT, SIG_DFL);
	signal(SIGQUIT, SIG_DFL);
	signal(SIGTERM, SIG_DFL);
	signal(SIGALRM, SIG_DFL);
	signal(SIGHUP, SIG_DFL);

	exit(0);
}


void PrintUsage(FILE *f){
    fprintf(f, "Usage: ascii2netflow {options}\nwhere {options} are:\n\
            -h\t print help screen and exit\n\
            -q\t quiet output\n\
            -d\t debug output\n\
            -e export_to\t IP address:port to export flows to\n\
            -x expire check timeout (sec)\n\
            -a active_timeout\t active flow timeout (sec.)\n\
            -i inactive_timeout\t inactive flow timeout (sec.)\n");
}

void do_hup()
{
    Debug("SIGHUP\n");
    hupset = 1;
    signal(SIGHUP, (sig_t)do_hup);
}
//---------------------------------------------------------------------------------

int main(int argc, char **argv) {
	
	int status;
	int op;
	unsigned active=0,inactive=0;
	unsigned expired =0;	

	while((op=getopt(argc, argv, "hqde:p:a:i:x:")) != EOF){
		switch(op){
			case 'h':
				PrintUsage(stdout);
				exit(-1);
				break;
			case 'd':
				debug=1;
				break;
			case 'q':
				quiet=1;
				break;
			case 'e':
				destination=(char *)calloc(strlen(optarg)+1, 1);
				strcpy(destination, optarg);
				break;
			case 'a':
				active=strtol(optarg, NULL, 10);
				break;
			case 'i':
				inactive=strtol(optarg, NULL, 10);
				break;
			case 'x':
				expired=strtol(optarg, NULL, 10);
				break;
			default:
				PrintUsage(stdout);
				break;
		}
	}
	
	if (debug && !quiet) {
		printf("This is part of NeTAMS project, http://www.netams.com \n");
	}


	if (!destination)
		dst_host="127.0.0.1";
	else {
		char *c;
		c=strchr(destination, ':');
		if (c) {
			dst_port=strtol(c+1, NULL, 10);
			c[0]='\0'; dst_host=destination;
		} else
			dst_host=destination;
	}
    
	if (!active) active=10*60; // 10 min
	if (!inactive) inactive=1*60; // 1 min
	
	Flow=new NetFlow(dst_host,dst_port);   
	Flow->SetTimeouts(active,inactive,expired,active);	

	signal(SIGINT, (sig_t)termination);
	signal(SIGQUIT, (sig_t)termination);
	signal(SIGTERM, (sig_t)termination);
	signal(SIGHUP, (sig_t) do_hup);

	char buffer[1024];
	char *p1, *p2, *p3;
	unsigned long bytes;
	struct packet packet;
	SET_POLL(STDIN_FILENO);

	while(1) {
		CHECK_POLL(status);
                if(status==0) {
                        Flow->Expiresearch();
                        continue;
                }

				// read input line
				p1=fgets(buffer, 1024, stdin);
				
                if(p1==NULL) {
                        if (ferror(stdin)) {
                        	printf("ascii2netflow: error in input stream\n");
	                        continue;
                        }
                        if (feof(stdin)){
                        	Flow->Expiresearch();
                        	return 0;
                        }
                }
				/* 
				srcaddr=XX 
				{srcport=YY} 0
				dstaddr=XX 
				{dstport=YY} 0
				bytes=NN
				proto=NN
				*/
				
				bzero(&packet, sizeof (struct packet));
				bytes=0;
				p2=buffer-1; 
				do {
					p1=p2+1;
					p2=strchr(p1, ' ');
					if (p2) p2[0]='\0';
					p3=strchr(p1, '=');
					if (!p3) continue; else p3++;

					packet.ip.ip_hl=5;
					if (!strncasecmp(p1, "srcaddr", 7)) inet_aton(p3, &packet.ip.ip_src);
					else if (!strncasecmp(p1, "dstaddr", 7)) inet_aton(p3, &packet.ip.ip_dst);
					else if (!strncasecmp(p1, "proto", 5)) packet.ip.ip_p=atoi(p3);
					else if (!strncasecmp(p1, "bytes", 5)) bytes=atol(p3);
					else if (!strncasecmp(p1, "srcport", 7)) packet.tcp.th_sport=htons(atoi(p3));
					else if (!strncasecmp(p1, "dstport", 7)) packet.tcp.th_dport=htons(atoi(p3));
					
					if (debug && !quiet) printf("p1=%p, p2=%p, s= %s\n", p1, p2, p1);
					
					
					
				} while (p2!=NULL); 	
				
				
                 Flow->Expiresearch();
                if (bytes==0) continue;
                 
                 for (unsigned b=bytes/0xffff; b>0; b--){
                 	packet.ip.ip_len=htons(0xffff);
					if (debug && !quiet) printf(" chunk %d (%u)\n", b, ntohs(packet.ip.ip_len));
                 	Flow->Processpacket((struct ip*)&packet);
					}
                packet.ip.ip_len=htons(bytes%0xffff);
				if (debug && !quiet) printf(" chunk 0 (%u)\n", ntohs(packet.ip.ip_len));
                Flow->Processpacket((struct ip*)&packet);
        }

	return 0;
}

