#!/bin/sh
#
# $Id: netams-startup-freebsd6.sh,v 1.3 2008-01-03 12:44:54 anton Exp $ 
# 
# PROVIDE: netams 
# REQUIRE: NETWORKING 
# KEYWORD: FreeBSD 
# 
# Add the following line to /etc/rc.conf[.local] to enable netams 
#
# netams_enable (bool):         Set to "NO" by default.
#                               Set it to "YES" to enable netams.
# netams_config (str):          Custom configuration file to be passed
#                               to netams.
#
# contributed to NeTAMS project by Alexander Logvinov
# see: http://www.netams.com
#

. /etc/rc.subr

name="netams"
rcvar=${name}_enable

load_rc_config $name

: ${netams_enable="NO"}
: ${netams_config="/usr/local/etc/netams.conf"}

command="/usr/local/libexec/netams"
command_args="-lf ${netams_config} >/dev/null"
required_files="${netams_config}"

run_rc_command "$1"
