using System;
using System.IO;
using System.Text.RegularExpressions;

using NAnt.Core.Attributes;
using NAnt.DotNet.Tasks;

namespace Nemerle.Tools.NAntTasks
{
	[TaskName("ncc")]
	public class NccTask: CompilerBase 
	{
		private static _classNameRegex : Regex =  Regex(@"^((?<comment>/\*.*?(\*/|$))|[\s\.\{]+|class\s+(?<class>\w+)|(?<keyword>\w+))*");
		private static _namespaceRegex : Regex =  Regex(@"^((?<comment>/\*.*?(\*/|$))|[\s\.\{]+|namespace\s+(?<namespace>(\w+(\.\w+)*)+)|(?<keyword>\w+))*");
		private  mutable  _docFile : FileInfo; 
		private  mutable  _nostdlib : bool;
		private  mutable  _optimize : bool;

		protected override ClassNameRegex : Regex
		{
			get
			{
				 _classNameRegex;
			}
		}

		protected override NamespaceRegex : Regex
		{
			get
			{
				 _namespaceRegex;
			}
		}

		public override ProgramArguments : string 
		{
			// quoting is done in CompilerBase
			get {  "-from-file:" + base.ProgramArguments.Substring(1) + ""; }
		}

		protected override WriteOption(writer : TextWriter, name : string) :  void 
		{
			writer.WriteLine("-{0}", name);
		}

		protected override WriteOption(writer : TextWriter, name :  string, arg :  string) :  void 
		{
			writer.WriteLine("-{0}:{1}", name, arg);
		} 

		protected override WriteOptions(writer : TextWriter) :  void
		{
			when (DocFile != null) {
				WriteOption(writer, "xml", DocFile.FullName);
			}
			when (Debug) {
				WriteOption(writer, "debug");
				WriteOption(writer, "def", "DEBUG");
				WriteOption(writer, "def", "TRACE");
			}
			when (NoStdLib) {
				WriteOption(writer, "nostdlib");
				WriteOption(writer, "nostdmacros");
			}
			when (Optimize) {
				// WriteOption(writer, "Ot");
			}
			WriteOption(writer, "greedy-");
			WriteOption(writer, "no-color");
			WriteOption(writer, "bar-");
                }

		protected override NeedsCompiling() :  bool
		{
			if (DocFile != null)
			{
				if (!DocFile.Exists)
				{
					 true;
				}
				else
			        {
			            base.NeedsCompiling();
			        }
			}
			else
		        {
			    base.NeedsCompiling();
		        }
		}

		public override Extension : string
		{
			get
			{
				 "n";
			}
		}

		[TaskAttribute("doc")]
		public DocFile : FileInfo
		{
			get
			{
				 _docFile;
			}
			set
			{
				_docFile = value;
			}
		}

		[TaskAttribute("nostdlib")]
		[BooleanValidator()]
		public NoStdLib : bool
		{
			get
			{
				 _nostdlib;
			}
			set
			{
				_nostdlib = value;
			}
		}


		[TaskAttribute("optimize")]
		[BooleanValidator()]
		public Optimize : bool
		{
			get
			{
				 _optimize;
			}
			set
			{
				_optimize = value;
			}
		}
	}
}
