using System;
using Gtk;

public class DictBuffer : TextBuffer
{
  public this()
  {
    base(TextTagTable());  

    mutable  tag  = TextTag ("key");
    tag.Weight = Pango.Weight.Bold;
    tag.Scale = Pango.Scale.X_Large; 
    TagTable.Add (tag);
    
    tag = TextTag ("desc");
    tag.LeftMargin = 50;
    tag.RightMargin = 0;
    tag.WrapMode = WrapMode.Word;
    TagTable.Add (tag);
    
    tag = TextTag ("sim");
    tag.LeftMargin = 50;
    tag.PixelsAboveLines = 5;
    tag.Scale = Pango.Scale.XX_Small;
    tag.WrapMode = WrapMode.Word;
    TagTable.Add (tag);
  }
  
  public Insert (t : string) : void 
  {
    mutable i = GetIterAtMark (InsertMark);
    Insert (ref i, t);
  }
  
  public Insert (t : string, tgs : list[string]) : void
  {
      mutable begin = CharCount;
      Insert (t);
      mutable end = CharCount;
      
      foreach(t : string in tgs)
      {
        mutable endIter = GetIterAtOffset (end);
        mutable beginIter = GetIterAtOffset (begin);
        ApplyTag (t, beginIter, endIter);
      }

    }
}
