using System;
using System.IO;
using System.Net.Sockets;
using Nemerle.Collections;
   
namespace Chat
{
    
    // INTERFACES
    public interface IPacket
    {
        Send (stream : NetworkStream) : void;
    }
    
    // CLASSES
    
    public class EmptyMessageException : Exception
    {
        public this(){}
    }


    /**
     *  Clas representing message sent to other user
     */
    public class Message : IPacket
    {
        // CONSTRUCTOR
        public this (login : string, message : string)
        {
            this.login    = login;
            when(message == "")
                throw EmptyMessageException();
            this.message   = message;
        }

        // PUBLIC METHODS
        public Send(stream : NetworkStream) : void
        {
            mutable msg = "<message>";
            
            msg = msg + "<login>" + login + "</login>";
            msg = msg + "<message>" + message + "</message>";
            msg = msg + "</message>";

            def buffer = System.Text.Encoding.ASCII.GetBytes(msg);
            stream.Write(buffer,0,buffer.Length)
        }
        
        // PRIVATE FIELDS
        private login   : string;
        private message : string;
    }

    public class AddUserToList : IPacket
    {
        public this(login  : string)
        {
            this.login = login;
        }

        public Send(stream : NetworkStream) : void
        {
            mutable msg = "<addtolist>";
            msg = msg + "<login>" + login + "</login>";
            msg = msg + "</addtolist>";
            
            def buffer = System.Text.Encoding.ASCII.GetBytes(msg);
            stream.Write(buffer,0,buffer.Length)
        }

        private login : string;
    }

    public class RemoveUserFromList : IPacket
    {
        public this(login  : string)
        {
            this.login = login;
        }

        public Send(stream : NetworkStream) : void
        {
            mutable msg = "<removefromlist>";
            msg = msg + "<login>" + login + "</login>";
            msg = msg + "</removefromlist>";
            
            def buffer = System.Text.Encoding.ASCII.GetBytes(msg);
            stream.Write(buffer,0,buffer.Length)
        }

        private login : string;
    }
    
    
    /**
     *  Class used to connect to server
     */
    public class Connect : IPacket
    {
        // CONSTRUCTOR
        public this (login :string)
        {
            this.login = login;
        }

         // PUBLIC METHODS
        public Send(stream : NetworkStream) : void
        {
            mutable msg = "<connect>";
            msg = msg + "<login>" + login + "</login>";
            msg = msg + "</connect>";
            
            def buffer = System.Text.Encoding.ASCII.GetBytes(msg);
            stream.Write(buffer,0,buffer.Length)
        }
        
        // PRIVATE FIELDS
        private login : string;
    }

    /**
     *  Class used to disconnect from server
    */
    public class Disconnect : IPacket
    {
        // CONSTRUCTOR
        public this (login :string)
        {
            this.login = login;
        }

         // PUBLIC METHODS
        public Send(stream : NetworkStream) : void
        {
            mutable msg = "<disconnect>";
            msg = msg + "<login>" + login + "</login>";
            msg = msg + "</disconnect>";

            def buffer = System.Text.Encoding.ASCII.GetBytes(msg);
            stream.Write(buffer,0,buffer.Length)
        }
        
        // PRIVATE FIELDS
        private login : string;
    }

    public class SendUserList : IPacket
    {
        // CONSTRUCTOR
        public this (table : Hashtable[string,NetworkStream] )
        {
            this.table = table;
        }
        
        // PUBLIC METHODS 
        public Send(stream : NetworkStream) : void
        {
            mutable msg = "<userlist>";

            foreach(s in table)
            {
                //Console.WriteLine(s.Key.ToString() + " " + s.Value.ToString());
                msg = msg + "<login>" +s.Key.ToString() + "</login>" ;
            };

            msg = msg + "</userlist>";
            
            def buffer = System.Text.Encoding.ASCII.GetBytes(msg);
            stream.Write(buffer,0,buffer.Length)
        }

        // PRIVATE FIELDS
        private table : Hashtable [string,NetworkStream];
    }
}
