// Compiler options: -doc:xml-013.xml
using System;

namespace Testing
{
	public class Test
	{
		public static Main () :  void
		{
		}

		/// <summary>
		/// comment for public property
		/// </summary>
		public PublicProperty : string {
			/// <summary>
			/// On public getter - no effect
			/// </summary>
			get {  null; }
			/// <summary>
			/// On public setter - no effect
			/// </summary>
			set { _ = value; }
		}

		/// <summary>
		/// incorrect comment for public property
		/// </incorrect>
		public PublicProperty2 : string { // W: .*summary
			get {  null; }
		}

		/**
		<summary>
		Javadoc comment for public property
		</summary>
		*/
		public PublicProperty3 : string {
			/**
			<summary>
			On public getter - no effect
			</summary>
			*/
			get {  null; }
			/**
			<summary>
			On public setter - no effect
			</summary>
			*/
			set { _ = value }
		}
	}
}
/*
BEGIN-OUTPUT
END-OUTPUT
*/
// OPTIONS: -doc:xml-013.xml
