// Compiler options: 
//
// Test for contravariance support in delegates
//

using System;

 public class A {
	 protected  mutable  name : string;
	 
	 public this ( name : string)
	 {
		 this.name = "A::" + name;
	 }

	 public this ()
	 {
	 }

	 public Name : string {
		 get {
			  name;
		 }
	 }
 }

 public class B : A {
	 public this ( name : string)
	 {
		 this.name = "B::" + name;
	 }

	 public this ()
	 {
	 }
 }

 public class C : B {
	  mutable  value : string;

	 public this ( name : string, value :  string)
	 {
		 this.name = "C::" + name;
		 this.value = value;
	 }

	 public Value : string {
		 get {
			  value;
		 }
	 }
 }

 public class Tester {

	 delegate MethodHandler ( c : C) :  string;

	 static MethodSampleA ( value : A) :  string
	 {
		  value.Name;
	 }

	 static MethodSampleB ( value : B) :  string
	 {
		  value.Name;
	 }

	 static MethodSampleC ( value : C) :  string
	 {
		  value.Name + " " + value.Value;
	 }

	 static Main () :  void
	 {
		 mutable  da = MethodSampleA;
		 mutable  db = MethodSampleB;
		 mutable  dc = MethodSampleC;

		 mutable  a =  C ("Hello", "hello");
		 mutable  b =  C ("World", "world");
		 mutable  c =  C ("!", "!!!");

		 Console.WriteLine (da (a));
		 Console.WriteLine (db (b));
		 Console.WriteLine (dc (c));
	 }
	
 }
/*
BEGIN-OUTPUT
C::Hello
C::World
C::! !!!
END-OUTPUT
*/
