// Compiler options: 
// Test for covariance support in delegates
//

using System;

 public class A {
	 protected  mutable  name : string;
	 
	 public this ( name : string)
	 {
		 this.name = "A::" + name;
	 }

	 public this ()
	 {
	 }

	 public Name : string {
		 get {
			  name;
		 }
	 }
 }

 public class B : A {
	 public this ( name : string)
	 {
		 this.name = "B::" + name;
	 }

	 public this ()
	 {
	 }
 }

 public class C : B {
	 public this ( name : string)
	 {
		 this.name = "C::" + name;
	 }
 }

 public class Tester {

	 delegate MethodHandler ( name : string) :  A;

	 static MethodSampleA ( name : string) :  A
	 {
		   A (name);
	 }

	 static MethodSampleB ( name : string) :  B
	 {
		   B (name);
	 }

	 static MethodSampleC ( name : string) :  C
	 {
		   C (name);
	 }

	 static Main () :  void
	 {
		 mutable  a = MethodSampleA;
		 mutable  b = MethodSampleB;
		 mutable  c = MethodSampleC;

		 mutable  instance1 = a ("Hello");
		 mutable  instance2 = b ("World");
		 mutable  instance3 = c ("!");

		 Console.WriteLine (instance1.Name);
		 Console.WriteLine (instance2.Name);
		 Console.WriteLine (instance3.Name);
	 }
	
 }
/*
BEGIN-OUTPUT
A::Hello
B::World
C::!
END-OUTPUT
*/
