/**
 * Navit, a modular navigation system.
 * Copyright (C) 2005-2008 Navit Team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA  02110-1301, USA.
 */

#ifndef NAVIT_COLOR_H
#define NAVIT_COLOR_H

struct color {
	int r,g,b,a;
};

#define COLOR_WHITE ((struct color) {0xffff,0xffff,0xffff,0xffff})
#define COLOR_BLACK ((struct color) {0x0000,0x0000,0x0000,0xffff})
#define COLOR_TRANSPARENT ((struct color) {0x0000,0x0000,0x0000,0x0000})
#define COLOR_FMT "0x%x,0x%x,0x%x,0x%x"
#define COLOR_ARGS(c) (c).r,(c).g,(c).b,(c).a

#define COLOR_IS_SAME(c1,c2) ((c1).r==(c2).r && (c1).g==(c2).g && (c1).b==(c2).b && (c1).a==(c2).a)
#define COLOR_IS_WHITE(c) COLOR_IS_SAME(c, COLOR_WHITE)
#define COLOR_IS_BLACK(c) COLOR_IS_SAME(c, COLOR_BLACK)

#endif
