# -*-ruby-*-
#
# Copyright (c) 2004-2005 SASADA Koichi <ko1 at atdot.net>
#
# This program is free software with ABSOLUTELY NO WARRANTY.
# You can re-distribute and/or modify this program under
# the same terms of the Ruby's license.
#
#
# $Id: backlogbot.nb 181 2007-02-20 15:39:21Z znz $
#

=begin

== Abstract

BackLogBot support rich backlog management scheme.


== Configuration

#
# Maybe you don't have to write config(default setting is very useful)
#
BotConfig = [
{
  :name   => :BackLogBot,
  
  :clear       => false,        # if true, clear backlogs when output once
  :talker      => false,        # if true, talker will be pseudo talker 
  :prefix      => 'BL',
  :sender      => 'backlogbot',
  :time_format => '%m/%d-%H:%M',
}
]

=end


class BackLogBot < Nadoka::NDK_Bot
  def bot_initialize
    @stores = @logger.message_stores
    @talker = @bot_config.fetch(:talker, false)
    @clear  = @bot_config.fetch(:clear, false)
    @prefix = @bot_config.fetch(:prefix, 'BL')
    @sender = @bot_config.fetch(:sender, 'backlogbot')
    @sepr   = @bot_config.fetch(:separate, true)
    @tmfmt  = @bot_config.fetch(:time_format, '%m/%d-%H:%M')
    @msgfmts= @bot_config.fetch(:message_format, @config.default_log[:message_format])
  end

  def channel_message? ch
    /\A[\&\#\+\!]/ =~ ch
  end

  def on_client_login client_count, client
    @stores.each_channel_pool{|ch, msgobjs|
      if @state.current_channels[ch]
        msgobjs.each{|msgobj|
          msg  = @config.log_format_message(@msgfmts, msgobj)
          rch  = msgobj[:ch]
          time = msgobj[:time]

          cmd = Cmd.notice(rch, "#{@prefix}(#{time.strftime(@tmfmt)}) #{msg}")
          client.add_prefix(cmd, @talker ? nick : @sender)
          client.send_msg cmd
        }
      else
        msgobjs.each{|msgobj|
          if ch == :__talk__
            msg  = @config.log_format_message(@config.talk_log[:message_format], msgobj)
          else
            msg  = @config.log_format_message(@config.system_log[:message_format], msgobj)
          end
          
          rch  = msgobj[:ch]
          time = msgobj[:time]
          
          cmd = Cmd.notice(@state.nick, "#{@prefix}(#{time.strftime(@tmfmt)}) #{msg}")
          client.send_msg cmd
        }
      end
    }
    @stores.clear if @clear
  end
end



