#ifndef __WB_MYSQL_TABLE_EDITOR_OPT_PAGE_H__
#define __WB_MYSQL_TABLE_EDITOR_OPT_PAGE_H__

#include "grt/tree_model.h"
#include <gtkmm/builder.h>

class MySQLTableEditorBE;
class DbMySQLTableEditor;

//==============================================================================
//
//==============================================================================
class DbMySQLTableEditorOptPage
{
  public:
    DbMySQLTableEditorOptPage(DbMySQLTableEditor *owner, MySQLTableEditorBE* be, Glib::RefPtr<Gtk::Builder> xml);

    void refresh();

    void switch_be(MySQLTableEditorBE* be);
      
  private:
    void set_table_option(const std::string& value, const char* option);
    void set_toggled_table_option(const char* option);
    
    void set_pack_keys();
    void set_row_format();
    void set_merge_method();
  
    DbMySQLTableEditor                       *_owner;
    MySQLTableEditorBE                       *_be;
    Glib::RefPtr<Gtk::Builder>                               _xml;

    bool                                      _refreshing;
};

#endif
