/* 
 * Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef _WF_POPOVER_H_
#define _WF_POPOVER_H_

#include "mforms/popover.h"

#include "wf_mforms.h"

using namespace System;
using namespace Windows::Forms;
using namespace System::Drawing::Drawing2D;

namespace MySQL {
  namespace Forms {

    // The actual popover window.
    private ref class PopoverControl : Windows::Forms::Form
    {
    private:
      int cornerSize;
      int animationSteps;
      bool animated;
      System::Drawing::Point hotSpot;
      System::Drawing::Size baseSize;
      System::Drawing::Bitmap^ contentBitmap;
      mforms::StartPosition relativePosition;
      GraphicsPath^ outline;

    protected:
      virtual void OnKeyPress(KeyPressEventArgs^ e) override;

      virtual void OnPaint(PaintEventArgs ^e) override;
      void UpdateAndShowPopover(bool doAnimated);
      void ComputeOutline();
      void ComputeCoordinatesAndPadding();

    public:
      PopoverControl();

      void SetBaseSize(int width, int height);
      void DoRepaint();
      void Show(int x, int y, mforms::StartPosition position);
      void HidePopup();

      virtual property MySQL::Geometry::Rect DisplayRect
      {
        MySQL::Geometry::Rect get()
        {
          System::Drawing::Rectangle content_area= ClientRectangle;
          content_area.X += Padding.Left;
          content_area.Y += Padding.Top;
          content_area.Width -= Padding.Horizontal;
          content_area.Height -= Padding.Vertical;

          return MySQL::Geometry::Rect(content_area.Left, content_area.Top, content_area.Width, content_area.Height);
        }
      }

      virtual property bool ShowWithoutActivation
      {
        bool get() override { return true; }
      }

      virtual property Windows::Forms::CreateParams^ CreateParams	
      {
        Windows::Forms::CreateParams^ get() override
        {
          Windows::Forms::CreateParams^ cp = Form::CreateParams;

          //cp->ExStyle |= (int) MySQL::Utilities::SysUtils::WS::EX_LAYERED;
          cp->ExStyle |= (int) MySQL::Utilities::SysUtils::WS::EX_NOACTIVATE;
          cp->ClassStyle |= CS_DROPSHADOW;

          return cp;
        }
      }
    };

    public ref class PopoverImpl : public ObjectImpl
    {
    protected:
      PopoverImpl(mforms::Popover *self);
      ~PopoverImpl();

      static bool create(mforms::Popover* self);
      static void set_content(mforms::Popover* self, mforms::View* content);
      static void set_size(mforms::Popover* self, int width, int height);
      static void show(mforms::Popover* self, int spot_x, int spot_y, mforms::StartPosition position);
      static MySQL::Geometry::Rect get_content_rect(mforms::Popover* self);
      static void close(mforms::Popover* self);

    public:
      static void init(Manager ^mgr)
      {
        mforms::ControlFactory *f= mforms::ControlFactory::get_instance();

        DEF_CALLBACK1(bool, mforms::Popover*, mgr, f->_popover_impl, PopoverImpl, create);
        DEF_CALLBACK2(void, mforms::Popover*, mforms::View*, mgr, f->_popover_impl, PopoverImpl, set_content);
        DEF_CALLBACK3(void, mforms::Popover*, int, int, mgr, f->_popover_impl, PopoverImpl, set_size);
        DEF_CALLBACK4(void, mforms::Popover*, int, int, mforms::StartPosition, mgr, f->_popover_impl, PopoverImpl, show);
        DEF_CALLBACK1(void, mforms::Popover*, mgr, f->_popover_impl, PopoverImpl, close);
      }
    };

  };
};

#endif // _WF_POPOVER_H_
