//
//  MWReverseEngineering.h
//  MySQL Workbench
//
//  Created by Alfredo Kojima on 05/8/30.
//  Copyright 2005 MySQL AB. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <MySQLGRT/MGRT.h>
#import <MySQLGRT/MGRTConnectionPanel.h>

@class MVerticalBox;

@interface MWReverseEngineering : NSWindowController
{
  IBOutlet NSButton *nextButton;
  IBOutlet NSButton *backButton;
  IBOutlet NSButton *cancelButton;
  IBOutlet NSButton *detailsButton;
  IBOutlet NSTabView *tabView;
  IBOutlet NSTextField *caption;
  IBOutlet NSTextField *description;
  IBOutlet NSImageView *sakila;
  
  IBOutlet NSBox *rdbmsBox;
  IBOutlet NSBox *paramBox;
  IBOutlet NSBox *advParamBox;
  
  IBOutlet NSTextView *logText;
  
  IBOutlet NSImageView *connImage;
  IBOutlet NSImageView *schemaListImage;
  IBOutlet NSTextField *fetchSchemaResult;
  IBOutlet NSBox *fetchSchemaAdvBox;
  
  IBOutlet NSTableView *schemaSelectionList;
  
  IBOutlet NSImageView *revEngImage;
  IBOutlet NSImageView *checkImage;
  IBOutlet NSTextField *revEngResult;
  IBOutlet NSBox *revEngAdvBox;

  IBOutlet NSPopUpButton *plAlgoPop;
  IBOutlet NSTabView *plOptions;
  IBOutlet NSPopUpButton *plWidthPop;
  IBOutlet NSPopUpButton *plSpacePop;
  
  IBOutlet NSImageView *finRevEngImage;
  IBOutlet NSImageView *finAddImage;
  IBOutlet NSImageView *finPlaceImage;
  IBOutlet NSTextField *finResult;
  IBOutlet NSBox *finAdvBox;
  
  IBOutlet NSProgressIndicator *progress;
  
  IBOutlet NSScrollView *filterScrollView;
  
  MVerticalBox *_filterContent;

  NSImage *_taskUnchecked;
  NSImage *_taskChecked;
  NSImage *_taskError;
  NSImage *_taskDisabled;
 
  MGRT *_grt;
  MGRTConnectionPanel *_connPanel;
  
  MGRTValue *_schemaList;
  MGRTValue *_catalog;
  
  NSMutableArray *_schemaListObjects;
  
  NSMutableArray *_filterPanels;
  
  int _section;
  
  int _arrangeSchemaCount;
  BOOL _arrangeSchemaError;
  
  BOOL _advancedShown;
  
  BOOL _backWasEnabled;
  BOOL _nextWasEnabled;
}

- (IBAction)changedPlacementOption:(id)sender;

- (IBAction)goBack:(id)sender;
- (IBAction)goNext:(id)sender;
- (IBAction)cancel:(id)sender;
- (IBAction)showDetails:(id)sender;


- (id)initWithMGRT:(MGRT*)grt;

- (BOOL)run;

@end
