/* Copyright (C) 2005 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#ifndef _MWMAINWINDOW_H_
#define _MWMAINWINDOW_H_

#include "mywb.h"
#include <gtkmm/window.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/liststore.h>
#include <gtkmm/notebook.h>
#include <gtkmm/button.h>
#include <gtkmm/frame.h>
#include <gtkmm/spinbutton.h>
#include <gtkmm/tooltips.h>
#include <MySQLGRT/MGRT.h>
#include <MySQLGRT/MGRTValueTree.h>
#include <map>
#include "MWBCanvas.h"
#include "MGCanvasScroller.h"

class MGGladeXML;
class MGRTShell;
class MGRTObjectEditor;
class MWLayerTree;
class MGImageCheckButton;

class MWMainWindow : public Gtk::Window {
  public:
    enum ToolType {
      MWToolCursor = 0,
        MWToolPanning,
        MWToolEraser,
        MWToolTable,
        MWToolView,
        MWToolRoutine,
        MWToolRelationship1,
        MWToolRelationship2,
        MWToolRelationship3,
        MWToolImage,
        MWToolNote,
        MWToolLayer
    };

  protected:
    struct Message {
      char type;
      MYX_WB_GC_CHANGE msg;
      union {
        CGCView *view;
        MYX_GRT_VALUE *layer;
      } data;
    };
    
    class GRTValueColumns : public Gtk::TreeModel::ColumnRecord {
      public:
        GRTValueColumns() {
          add(text); add(value);
        };
        Gtk::TreeModelColumn<Glib::ustring> text;
        Gtk::TreeModelColumn<MGRTValue> value;
    } _grtvalue_columns;

    class PluginColumns : public Gtk::TreeModel::ColumnRecord {
      public:
        PluginColumns() {
          add(text); add(plugin); add(supported);
        };
        Gtk::TreeModelColumn<Glib::ustring> text;
        Gtk::TreeModelColumn<bool> supported;
        Gtk::TreeModelColumn<MGRTValue> plugin;
    } _plug_columns;

    class ColorColumns : public Gtk::TreeModel::ColumnRecord {
      public:
        ColorColumns() {
          add(color); add(value);
        };
        Gtk::TreeModelColumn<Glib::RefPtr<Gdk::Pixbuf> > color;
        Gtk::TreeModelColumn<MGRTValue> value;
    } _color_columns;

    class ZoomColumns : public Gtk::TreeModel::ColumnRecord {
      public:
        ZoomColumns() {
          add(text); add(zoom);
        };
        Gtk::TreeModelColumn<Glib::ustring> text;
        Gtk::TreeModelColumn<float> zoom;
    } _zoom_columns;
    
    struct ViewInfo {
      Gtk::Frame *frame;
      CGCView *view;
      Glib::RefPtr<Gtk::TreeStore> layer_tree;
      MYX_GRT_VALUE *root_layer;
    };

    MGGladeXML *_xml;
    MGGladeXML *_prop_xml;

    MGRT *_grt;
    MGRTShell *_grt_shell;

    MGRTValueTree *_schema_tree;
    MWLayerTree *_layer_tree;

    MGCanvasScroller *_canvas_scroll;
    MWBCanvas *_canvas;
    
    Gtk::Menu *_plugin_menu;
    Gtk::Menu _rel_menu;
    
    std::string _filename;

    Glib::Dispatcher _dispatch_message;
    Glib::Mutex _messages_mutex;
    std::list<Message> _messages;

    MGRTValue _relationship_context;
    
    Glib::Dispatcher _clipboard_copy_dispatcher;
    Glib::ustring _clipboard_copy_data;

    Glib::Dispatcher _input_req_dispatcher;
    Glib::ustring _input_req_caption;
    bool _input_req_password;
    Glib::ustring _input_req_text;
    bool _input_req_result;
    Glib::Mutex _input_ready;

    std::map<std::string,MGRTObjectEditor*> _editors;

    std::vector<ViewInfo> _views;

    Glib::RefPtr<Gtk::ListStore> _zoom_store;
    
    std::vector<Gdk::Cursor> _cursors;

    Glib::ustring _plugin_output;
    int _plugin_output_lines;
    Glib::RefPtr<Gtk::ListStore> _plugin_store;

    int _default_zoom_level;
    
    bool _schema_refresh_pending;
    bool _idle_refresh_pending;
    bool _selection_refresh_pending;
    bool _refreshing_selection;
    bool _refreshing_selection_tree;
    bool _adding_view_page;
    bool _has_selection;

    int _canvas_view_index;
    
    MGCanvas::Point _last_click_pos;
    
    bool _dirty;
    bool _untouched;
    bool _loading;

    Gtk::Button *_default_tool_button;
    MGImageCheckButton *_grid_check;
    Gtk::SpinButton *_space_spin;

    MGRTValue _current_object;
    
    ToolType _current_tool;
    
    Gtk::Tooltips _tooltips;

    Glib::RefPtr<Gtk::ListStore> _table_colors;
    Glib::RefPtr<Gtk::ListStore> _view_colors;
    Glib::RefPtr<Gtk::ListStore> _routine_colors;
    Glib::RefPtr<Gtk::ListStore> _layer_colors;
    Glib::RefPtr<Gtk::ListStore> _note_colors;
    Glib::RefPtr<Gtk::ListStore> _table_schemas;
    Glib::RefPtr<Gtk::ListStore> _table_charsets;
    Glib::RefPtr<Gtk::ListStore> _table_engines;
    Glib::RefPtr<Gtk::ListStore> _view_schemas;
    Glib::RefPtr<Gtk::ListStore> _routine_schemas;

    std::map<Glib::ustring, Gtk::Button*> _shortcut_map;
    
  public:
    void copy_to_clipboard(const char *text);
  protected:
    void do_copy_to_clipboard();

    static void view_callback(MYX_GRT *grt, MYX_GRT_VALUE *grtView, CGCView *view, MYX_WB_GC_CHANGE change, void *data);
    static void layer_callback(MYX_GRT *grt, MYX_GRT_VALUE *layer, CFigureInstance *gcLayer, MYX_WB_GC_CHANGE change, void *data);
    static void element_callback(MYX_GRT *grt, MYX_GRT_VALUE *element, CFigureInstance *gcElem, MYX_WB_GC_CHANGE change, void *data);

    bool request_input(Glib::ustring caption, bool password,
                       Glib::ustring *retval);

    void do_input_request();

    void change_detail_level(const char *layoutClass);
    void change_relationship_style(const char *styleClass);
    
    void plugin_tree_activated(const Gtk::TreeModel::Path&, Gtk::TreeViewColumn*);
    void plugin_search();
    void list_plugins_matching(const char *match, MGRTValue list,
                               MYX_GRT_VALUE **selection, int selection_count);

    void handle_canvas_action(CGCBase *object, TAction *action);
    bool handle_button_press(MGCanvas*canvas, int button, int modifiers, MGCanvas::Point pos);
    bool handle_button_release(MGCanvas*canvas, int button, int modifiers, MGCanvas::Point pos);
    
    bool handle_canvas_key(GdkEventKey *event);

    int get_available_element_index(const char *format, const char *objectListPath);
    int get_available_layer_index();
    
    void editor_saved(MGRTObjectEditor *editor);
    void editor_closed(MGRTObjectEditor *editor);

    virtual bool on_delete_event(GdkEventAny *ev);

    bool tree_selection_is_draggable();

    void get_selected_tool_schema(const char *combo, MGRTValue &schema, Glib::ustring &name);
    
    void schema_drag_data_get(const Glib::RefPtr<Gdk::DragContext>& context, Gtk::SelectionData& selection_data, guint info, guint time);

    void schema_drag_begin(const Glib::RefPtr<Gdk::DragContext>& context);
    void schema_drag_end(const Glib::RefPtr<Gdk::DragContext>& context);
    
    bool canvas_drag_motion(const Glib::RefPtr<Gdk::DragContext>& context, int x, int y, guint time);
    void canvas_drag_leave(const Glib::RefPtr<Gdk::DragContext>& context, guint time);
    bool canvas_drag_drop(const Glib::RefPtr<Gdk::DragContext>& context, int x, int y, guint time);
    
    void update_title();

    void select_all();
    void send_to_back(bool front);
    
    void change_tool(int tool_index);
    
    void change_view_page(int n);
    void page_switch(GtkNotebookPage *page, guint n);

    void setup_schema_list(Glib::RefPtr<Gtk::ListStore> list);
    void setup_charset_list(Glib::RefPtr<Gtk::ListStore> list);
    void setup_color_list(Glib::RefPtr<Gtk::ListStore> list, const MGRTValue &colorList);
    void set_layer_colors(const MGRTValue &colors);

    void export_as_pdf();
    void export_as_png();
    
    void show_properties();
    void save_properties();
    
    void show_grt_console();
    void create_canvas_view();
    void change_zoom(int dir);
    void toggle_overview();
    void toggle_grid();
    void toggle_grid_mi();
    void set_marker(int marker);
    void go_marker(int marker);
    void update_marker_menu();
    
    void new_view_tab();

    void delete_relationship();
    void delete_object();
    
    void arrange_objects();
    void create_schema();

    void reverse_engineer();
    void synchronize_db(bool resync);
    void generate_script();
    
    bool delayed_handle_view_add(CGCView *view);
    void handle_message();
    
    void set_status_text(const Glib::ustring &text);

    bool tree_display_filter(MGRTValue value);

    void align_objects(int type);
    
    void setup_toolbar();
    
    void create_canvas();
    void setup_ui();
    void set_default_appoptions();
    
    void zoom_changed();
    void schemata_changed();

    void layer_tree_selection_changed();
    
    void show_about();

    void quit();

    void build_plugin_popup_menu(MGRTValue rootObj, MGRTValue object, Gtk::Menu *&menu);
    
    void plugin_output_handler(Glib::ustring text);
    void plugin_finished(const MGRTValue&result, bool error, void *data);
    void call_plugin(MGRTValue plugin);
    void call_plugin_for_object(MGRTValue plugin, MGRTValue target);
    void refresh_plugins_menu(MYX_GRT_VALUE **selection=NULL, int selection_count=0,
                              const MGRTValue &root=MGRTValue(), Gtk::Menu *menu=0);

    bool create_view_in_canvas(CGCView *view);
    
    bool idle_refresh();
    bool refresh_selection();
    void refresh_when_idle(bool canvas_only= true);
    void refresh_selection_when_idle();
    void set_dirty();
    
    void handle_element_delete(MGRTValue element);

    void set_elements_expanded(bool compartments, bool expanded);
    
    bool check_document_empty();
    
    void dbd4_import_finished(const MGRTValue&result, bool error, void *data);
    void import_dbd4();
    
    void object_property_changed(const char *prop);
    void show_object_properties(MGRTValue object);
    
    MGRTValue edit_schema(MGRTValue args);
    MGRTValue edit_table(MGRTValue args);
    MGRTValue edit_view(MGRTValue args);
    MGRTValue edit_routine_group(MGRTValue args);
    MGRTValue popup_plugins_menu(MGRTValue args);
    MGRTValue popup_connection_menu(MGRTValue args);
  public:
    MWMainWindow(GtkWindow *win);
    static MWMainWindow *create();
    
    void setup();
    

    void open_document(const std::string &file);
    void save_document();
    void save_document_as();
    void new_document(bool new_instance= false);
};

#endif /* _MWMAINWINDOW_H_ */
