/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                       http://www.mrpt.org/                                |
   |                                                                           |
   |   Copyright (C) 2005-2011  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#ifndef _mrpt_math_H
#define _mrpt_math_H

#include <mrpt/math/distributions.h>
#include <mrpt/math/transform_gaussian.h>
#include <mrpt/math/fourier.h>
#include <mrpt/math/utils.h>
#include <mrpt/math/ops_vectors.h>
#include <mrpt/math/ops_matrices.h>
#include <mrpt/math/ops_containers.h>

#include <mrpt/math/CLevenbergMarquardt.h>
#include <mrpt/math/CQuaternion.h>
#include <mrpt/math/CQuaternion.h>
#include <mrpt/math/ransac.h>
#include <mrpt/math/ransac_applications.h>
#include <mrpt/math/dijkstra.h>

#include <mrpt/math/CHistogram.h>
#include <mrpt/math/CMatrix.h>
#include <mrpt/math/CMatrixD.h>
#include <mrpt/math/CMatrixB.h>
#include <mrpt/math/CMatrixTemplateObjects.h>
#include <mrpt/math/CMatrixFixedNumeric.h>
#include <mrpt/math/CArray.h>

#include <mrpt/math/graphs.h>
#include <mrpt/math/CGraphPartitioner.h>
#include <mrpt/math/CPolygon.h>
#include <mrpt/math/geometry.h>

#include <mrpt/math/CSplineInterpolator1D.h>

#include <mrpt/math/lightweight_geom_data.h>
#include <mrpt/math/CSparseMatrixTemplate.h>
#include <mrpt/math/CSparseMatrix.h>

#include <mrpt/math/CAStarAlgorithm.h>
#include <mrpt/math/CBinaryRelation.h>
#include <mrpt/math/CMonteCarlo.h>
#include <mrpt/math/jacobians.h>

#include <mrpt/math/KDTreeCapable.h>
#include <mrpt/math/kmeans.h>
#include <mrpt/math/slerp.h>
#include <mrpt/math/model_search.h>

#endif
