/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2010  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#ifndef _mrpt_poses_H
#define _mrpt_poses_H

#include "poses/CPoint.h"
#include "poses/CPose.h"
#include "poses/CPoseOrPoint.h"
#include "poses/CPoint2D.h"
#include "poses/CPose2D.h"
#include "poses/CPosePDF.h"
#include "poses/CPoint3D.h"
#include "poses/CPose2DGridTemplate.h"
#include "poses/CPosePDFGaussian.h"
#include "poses/CPointPDF.h"
#include "poses/CPose3D.h"
#include "poses/CPose3DQuat.h"
#include "poses/CPosePDFGrid.h"
#include "poses/CPointPDFGaussian.h"
#include "poses/CPoint2DPDFGaussian.h"
#include "poses/CPose3DPDF.h"
#include "poses/CPosePDFParticles.h"
#include "poses/CPointPDFParticles.h"
#include "poses/CPose3DPDFGaussian.h"
#include "poses/CPosePDFSOG.h"
#include "poses/CPointPDFSOG.h"
#include "poses/CPose3DPDFParticles.h"
#include "poses/CPoses2DSequence.h"
#include "poses/CPose3DPDFSOG.h"
#include "poses/CPoses3DSequence.h"
#include "poses/CPose3DInterpolator.h"
#include "poses/CPoseRandomSampler.h"
#include "poses/CNetworkOfPoses.h"
#include "poses/CRobot2DPoseEstimator.h"
#include "poses/CPose3DQuatPDFGaussian.h"


#endif
