/*
 * Decompiled with CFR 0.152.
 */
package logformat.clog;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import logformat.clog.MixedDataInputStream;

public class RecRaw {
    public static final int RECTYPE = 1;
    private static final int BYTESIZE = 32;
    public Integer etype;
    public int data;
    public int srcloc;
    public String string;
    private int msg_tag = Integer.MIN_VALUE;
    private int msg_size = Integer.MIN_VALUE;

    public int readFromDataStream(MixedDataInputStream mixedDataInputStream) {
        try {
            this.etype = new Integer(mixedDataInputStream.readInt());
            this.data = mixedDataInputStream.readInt();
            this.srcloc = mixedDataInputStream.readInt();
            mixedDataInputStream.skipBytes(4);
            this.string = mixedDataInputStream.readString(16);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
        if (this.etype == -101 || this.etype == -102) {
            this.setMsgParams();
        }
        return 32;
    }

    public int skipBytesFromDataStream(DataInputStream dataInputStream) {
        try {
            dataInputStream.skipBytes(32);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return 0;
        }
        return 32;
    }

    private void setMsgParams() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.string, " ");
        if (stringTokenizer.hasMoreTokens()) {
            this.msg_tag = Integer.parseInt(stringTokenizer.nextToken());
        }
        if (stringTokenizer.hasMoreTokens()) {
            this.msg_size = Integer.parseInt(stringTokenizer.nextToken());
        }
    }

    public int getMsgTag() {
        return this.msg_tag;
    }

    public int getMsgSize() {
        return this.msg_size;
    }

    public RecRaw copy() {
        RecRaw recRaw = new RecRaw();
        recRaw.etype = this.etype;
        recRaw.data = this.data;
        recRaw.srcloc = this.srcloc;
        recRaw.string = this.string;
        return recRaw;
    }

    public String toString() {
        if (this.etype == -101 || this.etype == -102) {
            return "RecRaw[ etype=" + this.etype + ", data=" + this.data + ", srcloc=" + this.srcloc + ", msg_tag=" + this.msg_tag + ", msg_size=" + this.msg_size + " ]";
        }
        return "RecRaw[ etype=" + this.etype + ", data=" + this.data + ", srcloc=" + this.srcloc + ", string=" + this.string + " ]";
    }
}

