var mgWindowTypes = {
  wTypes : new Object( {
    "chrome://browser/content/browser.xul"                             : ["browser",     "Firefox"],
    "chrome://global/content/viewPartialSource.xul"                    : ["viewsource",  "Firefox"],
    "chrome://global/content/viewSource.xul"                           : ["viewsource",  "Firefox", "Thunderbird"],
    "chrome://navigator/content/navigator.xul"                         : ["browser",     "SeaMonkey"],
    "chrome://navigator/content/viewSource.xul"                        : ["viewsource",  "SeaMonkey"],
    "chrome://navigator/content/viewPartialSource.xul"                 : ["viewsource",  "SeaMonkey"],
    "chrome://messenger/content/messenger.xul"                         : ["messenger",   "SeaMonkey", "Thunderbird"],
    "chrome://messenger/content/messageWindow.xul"                     : ["messenger",   "SeaMonkey", "Thunderbird"],
    "chrome://messenger/content/messengercompose/messengercompose.xul" : ["mailcompose", "SeaMonkey", "Thunderbird"]
  } ),

  getter : new Object ( {
    "browser"       : {contentArea  : function() {return gBrowser.mPanelContainer},
                       autoScroll   : function() {return gBrowser.mCurrentBrowser}},
    "viewsource"    : {contentArea  : function() {return document.getElementById('appcontent')},
                       autoScroll   : function() {return document.getElementById('content')}},
    "messenger"     : {contentArea  : function() {var tabC = document.getElementById('tabpanelcontainer');
                                                  return  tabC ? tabC : document.getElementById('messagepanebox')},
                       autoScroll   : function() {return document.getElementById('messagepane')}},
    "mailcompose"   : {contentArea  : function() {return document.getElementById('content-frame')},
                       autoScroll   : function() {return null}},
    "unknownWindow" : {contentArea  : function() {return document.documentElement},
                       autoScroll   : function() {return null}}
  } ),

  init : function() {
    var appInfo = Components.classes["@mozilla.org/xre/app-info;1"]
                  .getService(Components.interfaces.nsIXULAppInfo);

    var app = appInfo.name;

    switch(appInfo.ID) {
      case "{ec8030f7-c20a-464f-9b0e-13a3a9e97384}":
        app = "Firefox";
        break;
      case "{3550f703-e582-4d05-9a08-453d09bdfdc6}":
        app = "Thunderbird";
        break;
      case "{92650c4d-4b8e-4d2a-b7eb-24ecf4f6b63a}":
        app = "SeaMonkey";
        break;
    }

    var arr = new Array();

    for (each in this.wTypes) {
      var found = false;

      for (var x = 1; x < this.wTypes[each].length; x++) {
        if (this.wTypes[each][x] == app)
          found = true;
      }

      if (!found)
        arr[arr.length] = each;
    }

    for (var y = 0; y < arr.length; y++)
      delete mgWindowTypes.wTypes[arr[y]];

    try {
      if (document.location in mgWindowTypes.wTypes)
        mgWindowType = mgWindowTypes.wTypes[document.location][0];
    }
    catch (err) {}
  },

  getContentArea : function() {
    return mgWindowTypes.getter[mgWindowType].contentArea();
  },

  stopAutoScroll : function() {
    var scrollable = mgWindowTypes.getter[mgWindowType].autoScroll();

    if (scrollable && scrollable.autoscrollEnabled) {
      if (scrollable._isScrolling || scrollable._scrollingView || scrollable._scrollable) {
        scrollable.stopScroll();

        try {
          if (scrollable._autoScrollPopup)
            scrollable._autoScrollPopup.popupBoxObject.hidePopup();
        }
        catch (e) {}

        return true;
      }
    }

    return false;
  }
}

var mgWindowType = "unknownWindow";
mgWindowTypes.init();