/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dionua@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "appconfig.h"

#include <qsettings.h>

appConfig *globalConfig;

appConfig::appConfig(QObject *parent, const char *name)
		: QObject(parent, name)
{
	cfg=new QSettings();
}


appConfig::~appConfig()
{}

void appConfig::loadConfig()
{
	QSettings cfg;
	cfg.setPath("moto4lin","moto4lin");
	strcpy(cfgACMdevice, cfg.readEntry("/moto4lin/device/cfgACMdevice","/dev/ttyACM0").latin1());
	cfgATvendor=cfg.readEntry("/moto4lin/device/cfgATvendor","22b8").toUInt(0,16);
	cfgATproduct=cfg.readEntry("/moto4lin/device/cfgATproduct","4902").toUInt(0,16);
	cfgP2Kvendor=cfg.readEntry("/moto4lin/device/cfgP2Kvendor","22b8").toUInt(0,16);
	cfgP2Kproduct=cfg.readEntry("/moto4lin/device/cfgP2Kproduct","4901").toUInt(0,16);
	cfgAutoConnect=cfg.readNumEntry("/moto4lin/device/cfgAutoConnect",0);
#ifdef LIBUSB_HAS_DETACH_KERNEL_DRIVER_NP
	cfgDetachDriver=cfg.readNumEntry("/moto4lin/device/cfgDetachDriver",0);
#endif
	cfgAutoUpdateFileList=cfg.readNumEntry("/moto4lin/filemanager/cfgAutoUpdateFileList",0);
	cfgAutoExpandDirTree=cfg.readNumEntry("/moto4lin/filemanager/cfgAutoExpandDirTree",0);
	cfgGoLastFolder=cfg.readNumEntry("/moto4lin/filemanager/cfgGoLastFolder",0);
	cfgLoadList=cfg.readNumEntry("/moto4lin/filemanager/cfgLoadList",0);

}

void appConfig::saveConfig()
{
	QSettings cfg;
	cfg.setPath("moto4lin","moto4lin");
	cfg.writeEntry(QString("/moto4lin/device/cfgACMdevice"), cfgACMdevice);
	cfg.writeEntry(QString("/moto4lin/device/cfgATvendor"), QString("%1").arg(cfgATvendor,0,16));
	cfg.writeEntry(QString("/moto4lin/device/cfgATproduct"), QString("%1").arg(cfgATproduct,0,16));
	cfg.writeEntry(QString("/moto4lin/device/cfgP2Kvendor"), QString("%1").arg(cfgP2Kvendor,0,16));
	cfg.writeEntry(QString("/moto4lin/device/cfgP2Kproduct"), QString("%1").arg(cfgP2Kproduct,0,16));
	cfg.writeEntry(QString("/moto4lin/device/cfgAutoConnect"), cfgAutoConnect);
#ifdef LIBUSB_HAS_DETACH_KERNEL_DRIVER_NP
	cfg.writeEntry(QString("/moto4lin/device/cfgDetachDriver"), cfgDetachDriver);
#endif
	cfg.writeEntry(QString("/moto4lin/filemanager/cfgAutoUpdateFileList"), cfgAutoUpdateFileList);
	cfg.writeEntry(QString("/moto4lin/filemanager/cfgAutoExpandDirTree"), cfgAutoExpandDirTree);
	cfg.writeEntry(QString("/moto4lin/filemanager/cfgGoLastFolder"), cfgGoLastFolder);
	cfg.writeEntry(QString("/moto4lin/filemanager/cfgLoadList"), cfgLoadList);
}


